% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCls.R
\name{getCls}
\alias{getCls}
\title{get base clustering results using SC3 based clustering methods.}
\usage{
getCls(X, ks = 10:15, dists = c("spearman", "pearson"),
  dim.reduc.prop = 0.05)
}
\arguments{
\item{X}{Log transformed gene expression matrix (Gene by Cell).}

\item{ks}{Number of cell clustering groups. Default set to ks = 10:15.}

\item{dists}{Distribution matrices to use. Default is set to c("spearman", "pearson"). "euclidean" can be added as well.}

\item{dim.reduc.prop}{Proportion of principal components to use for K-means clustering.}
}
\value{
A matrix object, Each row represent different clustering results.
}
\description{
Similarity matrix constructed using "pearson", "spearman" or "euclidean". K-means clustering is performed on first few number of principal components of similarity matrix.
}
\examples{

data(exdata)
exdata <- preprocessSC(exdata)
exdata <- exdata[1:3000, 1:80]
logdat <- log(exdata+1)
cls <- getCls(logdat)

}
\references{
Il-Youp Kwak, Wuming Gong, Kaoko Koyano-Nakagawa and Daniel J. Garry (2017+)
DrImpute: Imputing dropout eveents in single cell RNA sequencing data
}
\seealso{
\code{\link{DrImpute}}  \code{\link{preprocessSC}}
}
\author{
Il-Youp Kwak
}
