% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/informed_ds.R
\name{informed_ds}
\alias{informed_ds}
\title{David's Score method informed by prior information}
\usage{
informed_ds(contestants, convention, initial.ranks = NULL, interactions)
}
\arguments{
\item{contestants}{A dataframe with the identities of the contestants for 
                   each study period along with the relevant data for 
                   adding them to the hierarchy. There should be one row per
                   contestant per study period.
                   Periods should appear in chronological order.
                   The dataframe should contain the following columns: 
                   \describe{
                     \item{period}{Study period.}
                     \item{id}{Identity of contestant.}
                     \item{convention1}{The primary convention by which new
                     individuals are added to the hierarchy. Interpretation
                     of this column varies depending on the value of the 
                     \strong{convention} argument. If \strong{convention} = none, 
                     this column is optional.}
                     \item{convention2}{Optional. The secondary data for 
                     resolving ties in convention1. Interpretation
                     of this column varies depending on the value of the 
                     \strong{convention} argument.}
}}

\item{convention}{A flag determining how new individuals are added to the
hierarchy. The value of this flag influences how the convention1
and convention2 columns of the \strong{contestants} argument are interpreted.
Currently this function supports five options:
\describe{
 \item{none}{The standard David's Score procedure (using Dij) is run. 
 Individuals are not added according to prior information 
 and scores are calculated independently for each period.}
 \item{mri}{New contestants are added to the hierarchy
 according to maternal rank inheritance with youngest
 ascendancy. \strong{convention1} should be a vector of 
 mother identities for each contestant. \strong{convention2}
 should be an optional vector of intra-litter ranks (lower 
 numbers = higher rank) for resolving the order of 
 contestants from the same mother
 joining the hierarchy in the same study period.}
 \item{tenure}{New contestants are added to the hierarchy
 according their tenure in the group. \strong{convention1} should be a vector of 
 dates on which each contestant joined the group. \strong{convention2} should be an
 optional vector of numerical data for resolving ties
 in convention1 (e.g., body size). Higher values are 
 considered higher rank.}
 \item{age}{New contestants are added to the hierarchy
 according their age (older = higher rank).
 \strong{convention1} should be a vector of birthdates or 
 numerical age classes. \strong{convention2} should be an
 optional vector of numerical data for resolving ties
 in convention1 (e.g., body size). Higher values are 
 considered higher rank.}
 \item{phys_attr}{New contestants are added to the hierarchy
 according to some physical attribute (larger value = higher rank). 
 \strong{convention1} should be a vector of numerical attribute
 measurements. \strong{convention2} should be an
 optional vector of numerical data for resolving ties
 in convention1. Higher values are 
 considered higher rank.}
}}

\item{initial.ranks}{The initial ordering of individuals for the first study
period. Required if using maternal rank inheritance as the convention.
For other conventions, if initial.ranks is not specified,
 the order determined by convention1 is used to create the initial order.}

\item{interactions}{A dataframe of interaction data with the following columns:
\describe{
 \item{winner}{Identities of winners.}
 \item{loser}{Identities of losers.}
 \item{period}{Study period in which interactions occurred.}}}
}
\value{
Produces a dataframe with the following columns: 
         \describe{
         \item{period}{Study period.}
         \item{id}{Identity of contestant.}
         \item{score}{David's Score of contestant.}
         \item{rank}{Ordinal rank of contestant in study period. Lower numbers
         equal higher rank.}
         \item{stan.rank}{Rank of contestant standardized for group size.
         Values range from 1 (highest rank) to -1 (lowest rank).}
         \item{old.order}{Identity of contestants arranged in the previous order (the order they
         were in before updating the order based on observations from the current
         study period).}}
}
\description{
Use David's Score method to infer a dominance hierarchy over multiple study periods.
New contestants are added according to the convention specified by the user.
Scores are calculated using Dij and are normalized.  
Full description of the addition of new individuals is described
in Strauss & Holekamp (in revision). To run the original David's Score procedure,
use convention flag 'none'.
}
\examples{
##Informed ds
female.ranks <- informed_ds(contestants = C.crocuta.female$contestants, convention = 'mri',
initial.ranks = C.crocuta.female$initial.ranks,
interactions = C.crocuta.female$interactions)

##Standard ds
female.ranks <- informed_ds(contestants = C.crocuta.female$contestants, convention = 'none',
interactions = C.crocuta.female$interactions)                          

}
\references{
Strauss ED & Holekamp KE (in revision). Journal of Animal Ecology.
  
            de Vries H, Stevens JMG, Vervaecke H (2006). Animal Behavior.
}
