% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DysPIA.R
\name{DyspiaSimpleImpl}
\alias{DyspiaSimpleImpl}
\title{DyspiaSimpleImpl}
\usage{
DyspiaSimpleImpl(
  pathwayScores,
  pathwaysSizes,
  pathwaysFiltered,
  leadingEdges,
  permPerProc,
  seeds,
  toKeepLength,
  stats,
  BPPARAM
)
}
\arguments{
\item{pathwayScores}{Vector with enrichment scores for the pathways in the database.}

\item{pathwaysSizes}{Vector of pathway sizes.}

\item{pathwaysFiltered}{Filtered pathways.}

\item{leadingEdges}{Leading edge gene pairs.}

\item{permPerProc}{Parallelization parameter for permutations.}

\item{seeds}{Seed vector}

\item{toKeepLength}{Number of `pathways` that meet the condition for `minSize` and `maxSize`.}

\item{stats}{Named vector of gene pair-level scores. Names should be the same as in pathways of `pathwayDB`.}

\item{BPPARAM}{Parallelization parameter used in bplapply.
Can be used to specify cluster to run. If not initialized explicitly or
by setting `nproc` default value `bpparam()` is used.}
}
\value{
A table with DysPIA results. Each row corresponds to a tested pathway.
The columns are the following:
\itemize{
 \item pathway -- name of the pathway as in `names(pathway)`;
 \item pval -- an enrichment p-value;
 \item padj -- a BH-adjusted p-value;
 \item DysPS -- enrichment score, same as in Broad DysPIA implementation;
 \item NDysPS -- enrichment score normalized to mean enrichment of random samples of the same size;
 \item nMoreExtreme` -- a number of times a random gene pair set had a more extreme enrichment score value;
 \item size -- size of the pathway after removing gene pairs not present in `names(stats)`;
 \item leadingEdge -- vector with indexes of leading edge gene pairs that drive the enrichment.
}
}
\description{
Runs dysregulated pathway identification analysis for preprocessed input data.
}
