% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_provenance_metadata.R
\name{get_provenance_metadata}
\alias{get_provenance_metadata}
\title{Get provenance metadata}
\usage{
get_provenance_metadata(packageId, env = "production")
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(xml_document) Provenance metadata of \code{packageId}, representing
a <methodStep> element that can be inserted into the <methods> section of a
dependent data package. 

See the 
\href{https://CRAN.R-project.org/package=emld}{emld} library 
for more on working with EML as a list or JSON-LD. See the 
\href{https://CRAN.R-project.org/package=xml2}{xml2} library 
for working with EML as XML.
}
\description{
Generates the provenance metadata of a source data package
}
\examples{
\dontrun{

methodStep <- get_provenance_metadata("knb-lter-pal.309.1")
methodStep
#> {xml_document}
#> <methodStep>
#> [1] <description>\n  <para>This method step describes provenance-based ...
#> [2] <dataSource>\n  <title>Stable isotope composition (d18O) of seawat ...
}
}
\concept{Provenance}
