% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_recent_changes.R
\name{list_recent_changes}
\alias{list_recent_changes}
\title{List recent changes}
\usage{
list_recent_changes(
  fromDate = NULL,
  toDate = NULL,
  scope = NULL,
  as = "data.frame",
  env = "production"
)
}
\arguments{
\item{fromDate}{(character) Start date in the format "YYYY-MM-DDThh:mm:ss"}

\item{toDate}{(character) End date in the format "YYYY-MM-DDThh:mm:ss"}

\item{scope}{(character) Scope of data package}

\item{as}{(character) Format of the returned object. Can be: "data.frame" 
or "xml".}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(data.frame or xml_document) Recent changes and their corresponding 
packageId, scope, identifier, revision, principal, doi, serviceMethod, and 
date.
}
\description{
List all data package insert, update, and delete operations,
optionally specifying the date and time to and/or from which the changes
should be listed. An optional scope value can be specified to filter results
for a particular data package scope.
}
\examples{
\dontrun{

# Changes occurring in the first 3 days of 2021 for all scopes
dataPackageChanges <- list_recent_changes(
 fromDate = "2021-01-01T00:00:00",
 toDate = "2021-01-03T00:00:00"
)
}
}
\seealso{
Other Listing: 
\code{\link{list_data_descendants}()},
\code{\link{list_data_entities}()},
\code{\link{list_data_package_identifiers}()},
\code{\link{list_data_package_revisions}()},
\code{\link{list_data_package_scopes}()},
\code{\link{list_data_sources}()},
\code{\link{list_deleted_data_packages}()},
\code{\link{list_recent_uploads}()},
\code{\link{list_service_methods}()},
\code{\link{list_user_data_packages}()}
}
\concept{Listing}
