% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findLocalMax.R
\name{findLocalMax}
\alias{findLocalMax}
\alias{findLocalMax.EEM}
\alias{findLocalMax.matrix}
\alias{findLocalMax.numeric}
\title{Find local maximum peaks}
\usage{
findLocalMax(data, ...)

\method{findLocalMax}{EEM}(data, n, threshold = 0.7, showprint = TRUE, ...)

\method{findLocalMax}{matrix}(data, n, threshold = 0.7, showprint = TRUE,
  ...)

\method{findLocalMax}{numeric}(data, threshold = 0.7, showprint = TRUE, ...)
}
\arguments{
\item{data}{EEM data generated by \code{\link{readEEM}} function, unfolded EEM data 
generated by \code{\link{unfold}} function or  a vector of numeric values which have names in 
the format of EX...EM...}

\item{...}{(optional) further arguments passed to other methods}

\item{n}{sample number. The number should not exceed \code{length(EEM)}.}

\item{threshold}{threshold value in between 0 and 1. Lower the value to cover low peaks.}

\item{showprint}{logical value whether to print out the results or not}
}
\value{
return a character vector of peak names. If showprint = TRUE, it will also 
print a dataframe of indicating the value of local maximum peaks.
}
\description{
Find local maximum peaks in EEM data
}
\section{Methods (by class)}{
\itemize{
\item \code{EEM}: for EEM data created by \code{\link{readEEM}} function

\item \code{matrix}: for unfolded EEM data created by \code{\link{unfold}} function

\item \code{numeric}: for a vector of numeric values which have names in 
the format of EX...EM...
}}
\examples{
data(applejuice)
findLocalMax(applejuice, 1) 

applejuice_uf <- unfold(applejuice)
findLocalMax(applejuice_uf, 1) 

}

