% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readWQPSample.R
\name{readWQPSample}
\alias{readWQPSample}
\title{Import Sample Data from the Water Quality Portal for WRTDS}
\usage{
readWQPSample(siteNumber, characteristicName, startDate = "", endDate = "",
  verbose = TRUE, legacy = TRUE)
}
\arguments{
\item{siteNumber}{character site number.  If USGS, it should be in the form :'USGS-XXXXXXXXX...'}

\item{characteristicName}{character. Either a valid characteristic name, or a 5 digit 
USGS parameter code.}

\item{startDate}{character starting date for data retrieval in the form YYYY-MM-DD.
Default is empty quotes "" which will retrieve the full period of record.}

\item{endDate}{character ending date for data retrieval in the form YYYY-MM-DD.
Default is empty quotes "" which will retrieve the full period of record.}

\item{verbose}{logical specifying whether or not to display progress message}

\item{legacy}{logical specifying whether to use the "legacy" WQP services, or 
the new ones. Legacy works well for non-USGS sites. For USGS sites it is recommended
to use the \code{readNWISSample} function. Default is \code{TRUE}.}
}
\value{
A data frame 'Sample' with the following columns:
\tabular{lll}{
Name \tab Type \tab Description \cr
Date \tab Date \tab Date \cr
ConcLow \tab numeric \tab Lower limit of concentration \cr
ConcHigh \tab numeric \tab Upper limit of concentration \cr
Uncen \tab integer \tab Uncensored data (1=TRUE, 0=FALSE) \cr
ConcAve \tab numeric \tab Average concentration \cr
Julian \tab integer \tab Number of days since Jan. 1, 1850\cr
Month \tab integer \tab Month of the year [1-12] \cr 
Day \tab integer \tab Day of the year [1-366] \cr
DecYear \tab numeric \tab Decimal year \cr
MonthSeq \tab integer \tab Number of months since January 1, 1850 \cr
SinDY \tab numeric \tab Sine of the DecYear \cr
CosDY \tab numeric \tab Cosine of the DecYear
}
}
\description{
Imports data from the Water Quality Portal, so it could be STORET, USGS, or USDA data. 
This function gets the data from: \url{https://www.waterqualitydata.us}
For raw data, use readWQPdata.  This function will retrieve the raw data, 
compress it (summing constituents), then converts it to the Sample dataframe structure.
See chapter 7 of the EGRET user guide for more details.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# These examples require an internet connection to run
\donttest{
Sample_All <- readWQPSample('WIDNR_WQX-10032762','Specific conductance', '', '')
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[dataRetrieval]{readWQPdata}}, \code{dataRetrieval::whatWQPsites}, 
\code{\link[dataRetrieval]{readWQPqw}}, \code{\link{compressData}}, \code{\link{populateSampleColumns}}
}
\keyword{USGS}
\keyword{WRTDS}
\keyword{data}
\keyword{import}
