% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntersectEdge2Fw.R
\name{IntsctEdg2Fw}
\alias{IntsctEdg2Fw}
\title{To compute F score for significant edges from individual methods}
\usage{
IntsctEdg2Fw(s, w, k, fdr)
}
\arguments{
\item{s}{Matrix containing edge scores obtained from k numbers of methods with gene pairs in row and edge scores in column}

\item{w}{Matrix containing weight for all individual methods}

\item{k}{Numbers of independent methods considered for computing edge scores}

\item{fdr}{Cut-off for selecting significant edges}
}
\value{
Fw matrix containing F score for significant gene pairs
}
\description{
IntsctEdg2Fw computes the Fw score using Fisher's weighted method for the significant edges obtained in k numbers of individual methods. The probability values are combined to compute the Fw score which follows chi-square distribution. The significant edges (>fdr) are selected using intersection.
}
\details{
IntsctEdg2Fw function generates mixture distribution based on edge score for each method given column wise in s matrix. The probability value for each pair of gene obtained from mixture distribution are combined using Fisher's weighted method. The combined score Fw follows chi-square distribution with 2k degrees of freedom.
}
\examples{
#load "EGRNi" library and Edge score data
library(EGRNi)
data(Edgescore)
data(weight)
IntsctEdg2Fw(Edgescore,weight, k=4, fdr=0.1)
}
\references{
Sarkar, C., Parsad, R., Mishra, D.C. and Rai, A. (2020). An ensemble approach for gene regulatory network study in rice blast. Journal of Crop and Weed , 16 , 1-8.
}
\author{
Chiranjib Sarkar(cschiranjib9@gmail.com)
}
