% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mleMCR.R
\name{MCRfit}
\alias{MCRfit}
\title{Fit a Mixture Cure Rate (MCR) Survival Model}
\usage{
MCRfit(
  formula,
  data,
  dist = "weibull",
  link = "logit",
  tau = 1,
  maxit = 1000,
  tol = 1e-05
)
}
\arguments{
\item{formula}{A two-part formula of the form \code{Surv(time, status) ~ x | w}, where \code{x} are covariates for the survival part, and \code{w} are covariates for the cure fraction.}

\item{data}{A data frame containing the variables in the model.}

\item{dist}{A character string indicating the baseline distribution. Supported values are \code{"weibull"}, \code{"exponential"}, \code{"rayleigh"}, \code{"lognormal"}, \code{"loglogistic"}, and \code{"invgauss"}.}

\item{link}{A character string specifying the link function for the cure fraction. Options are \code{"logit"}, \code{"probit"}, \code{"plogit"}, \code{"rplogit"}, and \code{"cauchit"}.}

\item{tau}{A numeric value used when \code{link = "plogit"} or \code{"rplogit"}. Defaults to 1.}

\item{maxit}{Maximum number of iterations for the EM-like algorithm. Defaults to 1000.}

\item{tol}{Convergence tolerance. Defaults to 1e-5.}
}
\value{
An object of class \code{"MCR"}, which is a list containing:
\item{coefficients}{Estimated regression coefficients for the survival part.}
\item{coefficients_cure}{Estimated coefficients for the cure part.}
\item{scale}{Estimated scale parameter of the baseline distribution.}
\item{loglik}{Final log-likelihood value.}
\item{n}{Number of observations used in the model.}
\item{deleted}{Number of incomplete cases removed before fitting.}
\item{ep}{Estimated standard errors.}
\item{iter}{Number of iterations used for convergence.}
\item{dist}{Distribution used.}
\item{link}{Link function used.}
\item{tau}{Tau parameter used (if applicable).}
}
\description{
Fits a cure rate model using a flexible link function and a variety of survival distributions. The model accounts for a cured fraction through a logistic-type link and estimates the model via an EM-like algorithm.
}
\examples{
require(EMGCR)

data(liver2)
names(liver2)
liver2$sex <- factor(liver2$sex)
liver2$grade <- factor(liver2$grade)
liver2$radio <- factor(liver2$radio)
liver2$chemo <- factor(liver2$chemo)
str(liver2)
model <- MCRfit(
  survival::Surv(time, status) ~ age + sex + grade + radio + chemo |
    age + medh + grade + radio + chemo,
  dist = "loglogistic",
  link = "plogit",
  tau = 0.15,
  data = liver2
)
model

}
