% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{cnfm}
\alias{cnfm}
\alias{cnfm,binClst,numeric-method}
\alias{cnfm,binClstPath,missing-method}
\alias{cnfm,binClstStck,missing-method}
\alias{cnfm,binClst,binClst-method}
\title{Confusion matrix}
\usage{
cnfm(obj, ref, ...)

\S4method{cnfm}{binClst,numeric}(obj, ref, ret = FALSE, ...)

\S4method{cnfm}{binClstPath,missing}(obj, ref, ret = FALSE, ...)

\S4method{cnfm}{binClstStck,missing}(obj, ref, ret = FALSE, ...)

\S4method{cnfm}{binClst,binClst}(obj, ref, ret = FALSE, ...)
}
\arguments{
\item{obj}{A \link{binClst_instance} or \code{bnClstStck} instance.}

\item{ref}{A numeric vector with an expert/reference labeling of the data.

  A second \link{binClst_instance} (see details).}

\item{...}{Parameters \code{ref} and \code{ret} are optional.}

\item{ret}{A boolean value (defaults to FALSE). If ret=TRUE the confusion
matrix is returned as a matrix object.}
}
\value{
If ret=TRUE returns a matrix with the confusion matrix values.
}
\description{
\code{cnfm} computes the confusion matrix of the clustering with
  respect to an expert/reference labeling of the data. Also, it can be used
  to compare the labelings of two different clusterings of the same
  trajectory, (see details).
}
\details{
The confusion matrix yields marginal counts and Recall for each row, and
marginal counts, Precision and class F-measure for each column. The 3x2
subset of cells at the bottom right show (in this order): the overall
Accuracy, the average Recall, the average Precision, NaN, NaN, and the
overall Macro-F-Measure. The number of classes (expert/reference labeling)
should match or, at least not be greater than the number of clusters. The
overall value of the Macro-F-Measure is an average of the class F-measure
values, hence it is underestimated if the number of classes is lower than the
number of clusters.

If \code{obj} is a \link{binClstPath_instance} and there is a column "lbl" in
the obj@pth slot with an expert labeling, this labeling will be used by
default.

If \code{obj} is a \code{binClstStck} instance and, for all paths in the
stack, there is a column "lbl" in the obj@pth slot of each, this labeling
will be used to compute the confusion matrix for the whole stack.

If \code{obj} and \code{ref} are both a \link{binClst_instance} (e.g.
smoothed versus non-smoothed), the confusion matrix compares both labelings.
}
\examples{
# -- apply EMbC to the example path --
mybcp <- stbc(expth,info=-1)
# -- compute the confusion matrix --
cnfm(mybcp,expth$lbl)
# -- as we have expth$lbl the following also works --
cnfm(mybcp,mybcp@pth$lbl)
# -- or simply --
cnfm(mybcp)
# -- numerical differences with respect to the smoothed clustering --
cnfm(mybcp,smth(mybcp))
}
