% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETDQualitizer.R
\name{compute_data_quality_from_validation}
\alias{compute_data_quality_from_validation}
\title{Compute Data Quality Metrics from Validation Data}
\usage{
compute_data_quality_from_validation(
  gaze,
  unit,
  screen = NULL,
  advanced = FALSE,
  include_data_loss = FALSE
)
}
\arguments{
\item{gaze}{A `data.frame` containing gaze data. Must include columns `target_id`, `tar_x`, `tar_y`, `timestamp`,
and eye-specific columns such as `left_x`, `left_y`, `right_x`, `right_y`. Timestamps should be provided in milliseconds.}

\item{unit}{A character string specifying the unit of measurement for gaze and target coordinates in the gaze data.frame.
Must be either `"pixels"` or `"degrees"`.}

\item{screen}{An optional `ScreenConfiguration` object or numeric scalar used to convert pixel coordinates to degrees.
Required if `unit == "pixels"`.}

\item{advanced}{Logical. If `TRUE`, all available metrics are returned. If `FALSE`, only a simplified subset is included (default is FALSE).}

\item{include_data_loss}{Logical. If `TRUE`, includes data loss and effective frequency metrics in the output (default is FALSE).}
}
\value{
A `data.frame` with one row per eye-target combination, containing computed metrics:
  - `eye`, `target_id`: identifiers
  - `offset`, `offset_x`, `offset_y`: accuracy metrics (`offset_x`, `offset_y` only if `advanced` is `TRUE`)
  - `rms_s2s`, `rms_s2s_x`, `rms_s2s_y`: precision (RMS sample-to-sample) (`rms_s2s_x`, `rms_s2s_y` only if `advanced` is `TRUE`)
  - `std`, `std_x`, `std_y`: precision (standard deviation) (`std_x`, `std_y` only if `advanced` is `TRUE`)
  - `bcea`, `bcea_orientation`, `bcea_ax1`, `bcea_ax2`, `bcea_aspect_ratio`: precision (BCEA metrics) (`bcea_orientation`, `bcea_ax1`, `bcea_ax2`, `bcea_aspect_ratio` only if `advanced` is `TRUE`)
  - `data_loss`, `effective_frequency`: optional metrics if `include_data_loss = TRUE`
}
\description{
This function computes a set of data quality metrics for gaze data collected during the PsychoPy validation procedure
that is provided in the ETDQualitizer repository on github
(https://github.com/dcnieho/ETDQualitizer/tree/master/python/ETDQualitizer/stim).
It evaluates accuracy, precision, and optionally data loss and effective sampling frequency, per eye and per target.
}
\details{
This function uses the following methods in the `DataQuality` class to compute the returned results:
`accuracy()`, `precision_RMS_S2S()`, `precision_STD()`, `precision_BCEA()`, `data_loss_from_invalid()`, and `effective_frequency()`.
}
\examples{
\dontrun{
dq <- compute_data_quality_from_validation(gaze_data, unit = "pixels", screen = my_screen_config)
}

}
