% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rollsd.R
\name{rollsd}
\alias{rollsd}
\title{Rolling standard deviation}
\usage{
rollsd(cases, lag_t)
}
\arguments{
\item{cases}{the time series of the newly observed cases per unit of time (ideally per day).}

\item{lag_t}{integer - the size of the rolling window for which the rolling standard deviation is calculated (minimum/default value = 7, maximum recommended value = 30).}
}
\description{
-A function to compute the rolling standard deviation for a time series.
}
\examples{
data("Italy")
cases = mova(cases=Italy$Cases, r_a=7)
roll = rollsd(cases=cases,lag_t=7)


}
