% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/EXRQ.R
\name{est.gamma.func}
\alias{est.gamma.func}
\title{Estimation of the Extreme Value Index on the Original Scale}
\usage{
est.gamma.func(taus, Lam.Q, lam, a = 0, tol)
}
\arguments{
\item{taus}{a grid of intermediate high quantile levels}

\item{Lam.Q}{a vector of the same length as taus, representing the estimated intermediate conditional quantiles of Y (at taus) on the transformed scale}

\item{lam}{the power-transformation parameter}

\item{a}{location shift parameter in the power transformation (introduced to avoid negative y values)}

\item{tol}{the tolerance level for checking quantile crossing issue}
}
\value{
A list is returned with the following components.

gamma.x: the estimated EVI. If quantile crossing is too severe,
which suggests that the estimated intermediate conditional quantiles are unstable, then NA is returned.

Q: the estimated conditional quantile of Y on the original scale
}
\description{
This function estimates the extreme value index on the original scale based on the estimated intermediate conditional quantiles
on the transformed scale
}

