% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnsembleFit-class.R
\name{EnsembleFit}
\alias{EnsembleFit}
\title{The constructor for the \code{EnsembleFit} object}
\usage{
EnsembleFit(ensemble_data, samples = NULL, point_estimate = NULL)
}
\arguments{
\item{ensemble_data}{An \code{EnsembleData} object encapsulating the data used to fit the ensemble model.}

\item{samples}{A \code{stanfit} object containing the samples drawn from the fitted model. The default value is \code{NULL}.}

\item{point_estimate}{A \code{list} output of the optimised model. The default value is \code{NULL}.}
}
\value{
An object of class \code{EnsembleFit}
}
\description{
The constructor for an \code{EnsembleFit} object. This function need not be called as an \code{EnsembleFit} object is constructed automatically by the \code{fit_ensemble_model} function.
The \code{samples} slot contains the samples from the MCMC if a full sampling was completed, otherwise the \code{point_estimate} slot contains information about a point estimate.
}
\references{
Stan Development Team (2020). RStan: the R interface to Stan. R package version 2.21.2. https://mc-stan.org
}
\seealso{
\code{\linkS4class{EnsembleFit}}, \code{\link{fit_ensemble_model}},
}
