\name{economicEfficiency}
\alias{eco_eff}
\title{Economic efficiency}
\usage{
eco_eff(Net_return , Total_duration_of_the_crop)
}
\arguments{
\item{Net_return}{Net return ($/ha)}
\item{Total_duration_of_the_crop}{Total duration of the crop (in days)}
}
\value{
Economic efficiency ($/ha/day)
}
\description{
Economic efficiency refers to the optimal production and allocation of resources to maximize the wealth or welfare. It considers both production and consumption, ensuring that goods and services are produced at the lowest possible cost and distributed to those who value them the most.
}
\examples{
Net_return <- 7.2
Total_duration_of_the_crop <- 270
eco_eff(Net_return, Total_duration_of_the_crop)
}
\references{
Kumar, M., Rajkhowa, D.J., Meena, K.L., Rakesh, K., Zeliang, P.K., Kikon, E.L., Rangnamei, K.L., Namei, A., 2017. Effect of nutrient management in lowland rice for improving productivity, profitability and energetics under the mid hill of Nagaland. J. AgriSearch 4, 247–250.\\
Dutta, S. K., Layek, J., Yadav, A., Das, S. K., Rymbai, H., Mandal, S. & Mishra, V. K. (2023). Improvement of rooting and growth in kiwifruit (Actinidia deliciosa) cuttings with organic biostimulants. Heliyon, 9(7).
}
\keyword{Economic efficiency}

