% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadNHES.R
\name{downloadNHES}
\alias{downloadNHES}
\title{Instructions for Downloading and Unzipping NHES Files}
\usage{
downloadNHES(
  years = c(1991, 1993, 1995, 1996, 1999, 2001, 2003, 2005, 2007, 2012, 2016, 2019)
)
}
\arguments{
\item{years}{an integer vector of the assessment years. Valid years are
1991, 1993, 1995, 1996, 1999, 2001, 2003, 2005, 2007, 2012, 2016, and 2019.
The instructions are the same for each year, this is used as reference only.}
}
\description{
Provides instructions to download the public-use National Household Education Survey (NHES) data in SPSS (*.sav) format
             for use with the \code{readNHES} function.
             The data originates from the \href{https://nces.ed.gov/datalab/onlinecodebook}{NCES Online Codebook} zip files.
             This function works for data from the years
             1991, 1993, 1995, 1996, 1999, 2001, 2003, 2005, 2007, 2012, 2016, and 2019.
}
\note{
The NHES data files are additionally available from the \href{https://nces.ed.gov/nhes/dataproducts.asp}{NHES data product page}.  However,
      the data files provided at that page do not include all available years of data, and contain inconsistent data file formats.
}
\examples{
\dontrun{
#view instructions to manually download NHES data
downloadNHES()
}
}
\seealso{
\code{\link{readNHES}}
}
\author{
Tom Fink
}
