% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readBTLS.R
\name{readBTLS}
\alias{readBTLS}
\title{Connect to BTLS Data}
\usage{
readBTLS(dat_FilePath, spss_FilePath, verbose = TRUE)
}
\arguments{
\item{dat_FilePath}{a character value to the full path of the BTLS fixed-width (.dat) data file}

\item{spss_FilePath}{a character value to the full path of the SPSS syntax file to process the \code{dat_FilePath}}

\item{verbose}{a logical value that will determine if you want verbose output while the \code{readBTLS} function is running to indicate processing progress
(the default value is \code{TRUE})}
}
\value{
an \code{edsurvey.data.frame} for the BTLS waves 1 to 5 longitudinal dataset.
}
\description{
Opens a connection to the Beginning Teacher Longitudinal Study (BTLS) waves 1 through 5 data file and
             returns an \code{edsurvey.data.frame} with
             information about the file and data.
}
\details{
Reads the \code{spss_FilePath} file to parse the \code{dat_FilePath} to an \code{edsurvey.data.frame}.
         There is no cached data because the \code{dat_FilePath} format already is in fixed-width format.
}
\examples{
\dontrun{

fld <- "~/EdSurveyData/BTLS"
datPath <- file.path(fld, "ASCII Data File", "BTLS2011_12.dat")
spsPath <- file.path(fld, "Input Syntax for Stata and SPSS", "BTLS2011_12.sps")

#read in the data to an edsurvey.data.frame
btls <- readBTLS(datPath, spsPath, verbose = TRUE)

dim(btls)
}
}
\seealso{
\code{\link{readECLS_K2011}}, \code{\link{readNAEP}}, and \code{\link{getData}}
}
\author{
Tom Fink
}
