% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EigenR.R
\name{Eigen_complexSchur}
\alias{Eigen_complexSchur}
\title{Complex Schur decomposition}
\usage{
Eigen_complexSchur(M)
}
\arguments{
\item{M}{real or complex square matrix}
}
\value{
A list with the \code{T} and \code{U} matrices.
}
\description{
Complex Schur decomposition of a square matrix.
}
\details{
See \href{https://eigen.tuxfamily.org/dox/classEigen_1_1ComplexSchur.html}{Eigen::ComplexSchur}.
}
\examples{
library(EigenR)
M <- cbind(c(3, 2i, 1+3i), c(1, 1i, 1), c(5, 0, -2i))
schur <- Eigen_complexSchur(M)
T <- schur$T
U <- schur$U
M - U \%*\% T \%*\% t(Conj(U))
}
