% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EigenR.R
\name{Eigen_realSchur}
\alias{Eigen_realSchur}
\title{Real Schur decomposition}
\usage{
Eigen_realSchur(M)
}
\arguments{
\item{M}{real square matrix}
}
\value{
A list with the \code{T} and \code{U} matrices.
}
\description{
Real Schur decomposition of a square matrix.
}
\details{
See \href{https://eigen.tuxfamily.org/dox/classEigen_1_1RealSchur.html}{Eigen::RealSchur}.
}
\examples{
library(EigenR)
M <- cbind(c(3, 2, 3), c(1, 1, 1), c(5, 0, -2))
schur <- Eigen_realSchur(M)
T <- schur$T
U <- schur$U
M - U \%*\% T \%*\% t(U)
}
