% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EleChemr.R
\name{ChronAmp}
\alias{ChronAmp}
\title{Chrono amperometry digital simulation}
\usage{
ChronAmp(
  Co = 0.001,
  exptime = 1,
  Dx = 1e-05,
  Dm = 0.45,
  Temp = 298.15,
  n = 1,
  Area = 1,
  DerApprox = 2,
  l = 100,
  errCheck = FALSE,
  Method = "Euler"
)
}
\arguments{
\item{Co}{bulk concentration expressed in Molar}

\item{exptime}{experimental time to be simulated expressed in seconds}

\item{Dx}{diffusion coefficient expressed in cm^2/s}

\item{Dm}{simulation parameter, maximum 0.5 for explicit methods}

\item{Temp}{temperature in kelvin}

\item{n}{number of electrons involved in the process}

\item{Area}{area of the electrode expressed in cm^2}

\item{DerApprox}{number of point for the approximation of the first derivative}

\item{l}{number of time steps of the simulation}

\item{errCheck}{if true the function returns a list with parameters for CottrCheck function}

\item{Method}{method to be used for the simulation = "Euler" "BI" "RK4" "CN" "BDF"}
}
\value{
if errCheck == F a graph I vs t, if errCheck == T a list
}
\description{
Return a graph I vs t of the electrochemical process
}
\examples{
ChronAmp(Co = 0.001, exptime = 1, DerApprox = 2, Dm = 0.45, errCheck = FALSE, Method = "Euler")

}
