% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_df.R
\name{param.net_to_table}
\alias{param.net_to_table}
\title{Coerce a list of parameters to a \code{long.param.df}}
\usage{
param.net_to_table(params)
}
\arguments{
\item{params}{A list of parameters to be formatted into a \code{long.param.df}}
}
\value{
A \code{data.frame} of parameters.
}
\description{
Coerce a list of parameters to a \code{long.param.df}
}
\section{long.param.df}{

It is possible to set input parameters using a specifically formatted
\code{data.frame} object. The first 3 columns of this \code{data.frame} must
be:
\itemize{
\item \code{param}: The name of the parameter. If this is a non-scalar
parameter (a vector of length > 1), end the parameter name with the
position on the vector (e.g., \code{"p_1"}, \code{"p_2"}, ...).
\item \code{value}: the value for the parameter (or the value of the
parameter in the Nth position if non-scalar).
\item \code{type}: a character string containing either \code{"numeric"},
\code{"logical"}, or \code{"character"} to define the parameter object
class.
}

In addition to these 3 columns, the \code{data.frame} can contain any number
of other columns, such as \code{details} or \code{source} columns to document
parameter meta-data. However, these extra columns will not be used by
EpiModel.
}

