% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{gt_opts}
\alias{gt_opts}
\alias{generation_time_opts}
\title{Generation Time Distribution Options}
\usage{
gt_opts(dist = Fixed(1), default_cdf_cutoff = 0.001, weight_prior = TRUE)

generation_time_opts(
  dist = Fixed(1),
  default_cdf_cutoff = 0.001,
  weight_prior = TRUE
)
}
\arguments{
\item{dist}{A delay distribution or series of delay distributions . If no
distribution is given a fixed generation time of 1 will be assumed.  If
passing a nonparametric distribution the first element should be zero (see
\emph{Details} section)}

\item{default_cdf_cutoff}{Numeric; default CDF cutoff to be used if an
unconstrained distribution is passed as \code{dist}. If \code{dist} is already
constrained by having a maximum or CDF cutoff this is ignored. Note that
this can only be done for <dist_spec> objects with fixed parameters.}

\item{weight_prior}{Logical; if TRUE (default), any priors given in \code{dist}
will be weighted by the number of observation data points, in doing so
approximately placing an independent prior at each time step and usually
preventing the posteriors from shifting. If FALSE, no weight
will be applied, i.e. any parameters in \code{dist} will be treated as a single
parameters.}
}
\value{
A \verb{<generation_time_opts>} object summarising the input delay
distributions.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Returns generation time parameters in a format for lower level model use.
}
\details{
Because the discretised renewal equation used in the package does
not support zero generation times, any distribution specified here will be
left-truncated at one, i.e. the first element of the nonparametric or
discretised probability distribution used for the generation time is set to
zero and the resulting distribution renormalised.
}
\examples{
# default settings with a fixed generation time of 1
generation_time_opts()

# A fixed gamma distributed generation time
generation_time_opts(Gamma(mean = 3, sd = 2, max = 14))

# An uncertain gamma distributed generation time
generation_time_opts(
  Gamma(
    shape = Normal(mean = 3, sd = 1),
    rate = Normal(mean = 2, sd = 0.5),
    max = 14
  )
)

# An example generation time
gt_opts(example_generation_time)
}
\seealso{
\code{\link[=convert_to_logmean]{convert_to_logmean()}} \code{\link[=convert_to_logsd]{convert_to_logsd()}}
\code{\link[=bootstrapped_dist_fit]{bootstrapped_dist_fit()}} \code{\link[=Gamma]{Gamma()}} \code{\link[=LogNormal]{LogNormal()}} \code{\link[=Fixed]{Fixed()}}
}
