% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{plotSD}
\alias{plotSD}
\title{Plot the Signal Detection time series}
\usage{
plotSD(x, input, subRegionName, x.sts, x.algo)
}
\arguments{
\item{x}{dataframe (default \code{\link{SignalData}})}

\item{input}{list of parameters as defined in the Signal Detection Application (see \code{\link{runEpiSDApp}})

(i.e.  \code{list(disease, country, indicator, stratification, unit, daterange, algo, testingperiod)})}

\item{subRegionName}{character string, region label to use in the plot, if different than \code{input$RegionName} (optional)}

\item{x.sts}{sts object (optional), see \code{\link{stsSD}})}

\item{x.algo}{algo object (optional), see \code{\link{algoSD}})}
}
\value{
plot
}
\description{
Plot the Signal Detection time series including historical data, alarm detection period and alarms
}
\examples{
#-- Setting the parameters to run the report for
input <- list(
disease = "Salmonellosis",
country = "EU-EEA - complete series",
indicator = "Reported cases",
stratification = "Confirmed cases",
unit = "Month",
daterange = c("2010-01-01", "2016-12-31"),
algo = "FarringtonFlexible",
testingperiod = 5
)

#-- Plotting the signal detection output
plotSD(input = input)

}
\seealso{
\code{\link{SignalData}} \code{\link{runEpiSDApp}}
}
