% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epi_functions.R
\name{epi_analyze}
\alias{epi_analyze}
\title{Performs summary statistics, SIR modeling, DALY calculation, age standardization, diagnostic test evaluation, or NLP keyword extraction.}
\usage{
epi_analyze(
  data,
  outcome,
  population,
  group = NULL,
  type = c("summary", "sir", "daly", "age_standardize", "diagnostic", "nlp"),
  ...
)
}
\arguments{
\item{data}{Input data frame with relevant columns (e.g., cases, population, yll, yld, text).}

\item{outcome}{Outcome column name (character, e.g., "cases").}

\item{population}{Population column name (character, e.g., "population", required for summary).}

\item{group}{Grouping column name (character, e.g., "region", optional).}

\item{type}{Analysis type: "summary", "sir", "daly", "age_standardize", "diagnostic", "nlp".}

\item{...}{Additional parameters (e.g., N, beta, gamma for SIR).}
}
\value{
A data frame with analysis results.
}
\description{
Performs summary statistics, SIR modeling, DALY calculation, age standardization, diagnostic test evaluation, or NLP keyword extraction.
}
