% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxTest_supportingFunctions.R
\name{maxTestIU_func}
\alias{maxTestIU_func}
\title{An internal function of the EquiTrends Maximum Equivalence Testing procedure using the Intersection Union approach.}
\usage{
maxTestIU_func(
  data,
  equiv_threshold,
  vcov,
  cluster,
  alpha,
  n,
  no_periods,
  base_period,
  is_panel_balanced
)
}
\arguments{
\item{data}{The data.frame object containing the data for the test. Should be of the form what is returned by the \link[EquiTrends]{EquiTrends_dataconstr} function.}

\item{equiv_threshold}{The equivalence threshold for the test. If NULL, the minimum equivalence threshold for which the null hypothesis of non-negligible can be rejected is calculated.}

\item{vcov}{The variance-covariance matrix estimator. See \link[EquiTrends]{maxEquivTest} for more information.}

\item{cluster}{The cluster variable for the cluster-robust variance-covariance matrix estimator. See \link[EquiTrends]{maxEquivTest} for more information.}

\item{alpha}{The significance level for the test.}

\item{n}{The number of cross-sectional individuals in the data.}

\item{no_periods}{The number of periods in the data.}

\item{base_period}{The base period for the test. Must be one of the unique periods in the data.}

\item{is_panel_balanced}{A logical value indicating whether the panel data is balanced.}
}
\value{
An object of class "maxEquivTestIU" containing:
\item{\code{placebo_coefficients}}{A numeric vector of the estimated placebo coefficients,}
\item{\code{abs_placebo_coefficients}}{a numeric vector with the absolute values of estimated placebo coefficients,}
\item{\code{placebo_coefficient_se}}{a numeric vector with the standard errors of the placebo coefficients,}
\item{\code{significance_level}}{the chosen significance level of the test,}
\item{\code{num_individuals}}{the number of cross-sectional individuals (n),}
\item{\code{num_periods}}{the number of periods (T),}
\item{\code{num_observations}}{the total number of observations (N),}
\item{\code{base_period}}{the base period in the data,}
\item{\code{placebo_names}}{the names corresponding to the placebo coefficients,}
\item{\code{equiv_threshold_specified}}{a logical value indicating whether an equivalence threshold was specified.}
\item{\code{is_panel_balanced}}{a logical value indicating whether the panel data is balanced.}
 Additionally, if \code{!(is.null(equiv_threshold))}\itemize{
 \item{\code{IU_critical_values}: a numeric vector with the individual critical values for each of the placebo coefficients,}
 \item{\code{reject_null_hypothesis}: a logical value indicating whether the null hypothesis of negligible pre-trend differences can be rejected at the specified significance level \code{alpha},}
 \item{\code{equiv_threshold}: the equivalence threshold employed,}
}
if \code{is.null(equiv_threshold)}\itemize{
\item{\code{minimum_equiv_thresholds}: a numeric vector including for each placebo coefficient the minimum equivalence threshold for which the null hypothesis of negligible pre-trend differences can be rejected for the corresponding placebo coefficient individually,}
\item{\code{minimum_equiv_threshold}: a numeric scalar minimum equivalence threshold for which the null hypothesis of negligible pre-trend differences can be rejected for all placebo coefficients individually.}
}
}
\description{
This is a supporting function of the \code{maxEquivTest} function. It calculates the placebo coefficients and the absolute value of the placebo coefficients. It then calculates the critical value and p-values if an equivalence threshold is supplied for the test, according to Dette & Schumann (2024). If no equivalence threshold is supplied, it calculates the minimum equivalence threshold for which the null of non-negligible pre-trend differences can be rejected.
}
\references{
Dette, H., & Schumann, M. (2024). "Testing for Equivalence of Pre-Trends in Difference-in-Differences Estimation." \emph{Journal of Business & Economic Statistics}, 1–13. DOI: \doi{10.1080/07350015.2024.2308121}
}
