% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmsTest_supportingFunctions.R
\name{rmsTest_func}
\alias{rmsTest_func}
\title{An internal function of the RMS Equivalence Testing procedure}
\usage{
rmsTest_func(
  data,
  equiv_threshold,
  alpha,
  no_lambda,
  base_period,
  no_periods,
  is_panel_balanced
)
}
\arguments{
\item{data}{The data.frame object containing the data for the test. Should be of the form what is returned by the \link[EquiTrends]{EquiTrends_dataconstr} function.}

\item{equiv_threshold}{The equivalence threshold for the test. If NULL, the minimum equivalence threshold for which the null hypothesis can be rejected is calculated.}

\item{alpha}{The significance level for the test. Must be one of 0.01, 0.025, 0.05, 0.1 or 0.2.}

\item{no_lambda}{See \link[EquiTrends]{rmsEquivTest}.}

\item{base_period}{The base period for the test. Must be one of the unique periods in the data.}

\item{no_periods}{The number of periods in the data.}

\item{is_panel_balanced}{A logical value indicating whether the panel data is balanced.}
}
\value{
An object of class "rmsEquivTest" containing:
\item{\code{placebo_coefficients}}{A numeric vector of the estimated placebo coefficients,}
\item{\code{rms_placebo_coefs}}{the root mean squared value of the placebo coefficients,}
\item{\code{significance_level}}{the significance level of the test,}
\item{\code{num_individuals}}{the number of cross-sectional individuals in the data (n),}
\item{\code{num_periods}}{the number of pre-treatment periods in the data (T),}
\item{\code{num_observations}}{the number of observations in the data (N),}
\item{\code{base_period}}{the base period in the data,}
\item{\code{equiv_threshold_specified}}{a logical value indicating whether an equivalence threshold was specified.}
\item{\code{is_panel_balanced}}{a logical value indicating whether the panel data is balanced.}

If \code{is.null(equiv_threshold)}, then additionally \code{minimum_equiv_threshold}: the minimum equivalence threshold for which the null hypothesis of non-negligible (based on the equivalence threshold) trend-differnces can be rejected. 

if \code{!(is.null(equiv_threshold))}, then additionally
\itemize{
\item \code{rms_critical_value}: the critical value at the alpha level,
\item \code{reject_null_hypothesis}: A logical value indicating whether to reject the null hypothesis,
\item \code{equiv_threshold}: the equivalence threshold specified.
}
}
\description{
This is a supporting function of the \code{rmsEquivTest} function. It calculates the placebo coefficients and the RMS of the placebo coefficients. It then calculates the critical value for the test and checks whether the null hypothesis can be rejected, according to Dette & Schumann (2024).
}
\references{
Dette, H., & Schumann, M. (2024). "Testing for Equivalence of Pre-Trends in Difference-in-Differences Estimation." \emph{Journal of Business & Economic Statistics}, 1–13. DOI: \doi{10.1080/07350015.2024.2308121}
}
