% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.pgrid2.R
\name{create.pgrid2}
\alias{create.pgrid2}
\title{Create grid of locations.}
\usage{
create.pgrid2(xgrid, ygrid, midpoints = FALSE, poly.coords = NULL)
}
\arguments{
\item{xgrid}{A vector of locations in the x direction.}

\item{ygrid}{A vector of location in the y direction.}

\item{midpoints}{A logical value (\code{TRUE} or \code{FALSE}) indicating whether the boundary values are for the midpoint of a pixel (\code{midpoints = TRUE}) or for the boundary of the spatial domain in general (\code{midpoints = FALSE}, in which case the midpoints are calculated internally). Default is \code{FALSE}.}

\item{poly.coords}{An \eqn{n \times 2} matrix with the coordinates specifying the polygon vertices of the true spatial domain of interest within the rectangular boundaries provided by \code{xmin}, \code{xmax}, \code{ymin}, and \code{ymax}. If this is provided, the \code{pgrid} returned will be within the convex hull of \code{poly.coords}.}
}
\value{
Returns an object of class pgrid with the following components: 
\item{pgrid}{An \eqn{n \times 2} matrix of locations (the midpoints of the pixelized grid).}
\item{m}{The number of rows in pgrid.}
\item{p.in.grid}{A vector of 0s and 1s indicating whether the midpoint of each pixel is in the convex hull of \code{poly.coords}. If \code{poly.coords} is not provided, this is a vector of 1s.}
\item{ubx}{The pixel boundaries in the x-direction.}
\item{uby}{The pixel boundaries in the y-direction.}
\item{upx}{The pixel midpoints in the x-direction.}
\item{upy}{The pixel midpoints in the y-direction.}
}
\description{
\code{create.pgrid2} creates a grid of locations fusing vectors of x and y coordinates.
}
\details{
The key argument in the function midpoints. If this is \code{TRUE}, it is assumed that the boundaries of the spatial domain correspond to the midpoints of the cell/pixel in the grid. Otherwise, it is assumed that the boundaries correspond to the actual borders of the region of interest. If \code{poly.coords} is supplied, the grid returned is the grid of midpoints contained in the convex hull of \code{poly.coords}.
}
\examples{
seq1 = seq(0, 1, len = 101)
pgrida <- create.pgrid2(seq1, seq1, midpoint = FALSE)
seq2 = seq(.005, .995, len = 100)
pgridb <- create.pgrid2(seq2, seq2, midpoint = TRUE)
# pgrids produced match
range(pgrida$pgrid - pgridb$pgrid)
}
\author{
Joshua French
}
