% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirna_base_frequency.R
\name{basepreplot}
\alias{basepreplot}
\title{Plot the base frequency distribution diagram for small RNA (sRNA)}
\usage{
basepreplot(sRNAdata, width = 0.6, font_size = 10, title_size = 12)
}
\arguments{
\item{sRNAdata}{A data frame. Base frequency distribution of sRNAs.}

\item{width}{A numeric. Bar width, and default is 0.6.}

\item{font_size}{A numeric. Size of axis ticks and legend item labels, and default is 10.}

\item{title_size}{A numeric. Size of axis titles and legend titles, and default is 12.}
}
\value{
Base frequency distribution plot of sRNAs.
}
\description{
Plot the base frequency distribution diagram for small RNA (sRNA)
}
\examples{
#F1
F1_miRNA <- F1_miRNA_count[,1]
F1_bf <- mirnapredata(sRNAseq = F1_miRNA)
basepreplot(sRNAdata = F1_bf)
}
