% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full_factorial.R
\name{full_factorial}
\alias{full_factorial}
\title{Full Factorial Design}
\usage{
full_factorial(attributes_list)
}
\arguments{
\item{attributes_list}{A named list: giving the variable name and the levels as characters. The levels should start from the base of either "0" or "1" and go up in integer values.}
}
\value{
a `data.frame` with the full factorial design and factors coded using standardised orthogonal contrast coding.
}
\description{
Generates the full factorial design with all the factors coded using standardised orthogonal contrast coding.
}
\examples{
# See step 1 of the Practical Introduction to ExpertChoice vignette.
attrshort  = list(condition = c("0", "1", "2"),
technical =c("0", "1", "2"),
provenance = c("0", "1"))
full_factorial(attrshort)
}
\references{
Kuhfeld, W. F. Marketing Research Methods in SAS Experimental Design, Choice, Conjoint, and Graphical Techniques 2010.

Jörg Suckut (https://stats.stackexchange.com/users/237455/j%c3%b6rg-suckut), How to calculate (standardized) orthogonal contrast coding in R?, URL (version: 2019-02-12): https://stats.stackexchange.com/q/392173
}
