% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EzGP_fit.R
\name{EzGP_fit}
\alias{EzGP_fit}
\title{The Fitting Function of \code{EzGP} Model}
\usage{
EzGP_fit(
  X,
  Y,
  p,
  q,
  m,
  tau = 0,
  lb = "T",
  ub = "T",
  x0 = "T",
  xtol_rel = 1e-05,
  maxeval = 100,
  algorithm = "NLOPT_LD_LBFGS"
)
}
\arguments{
\item{X}{Matrix or data frame containing the inputs of training data. Each row represents the input setting of a data point and the columns are values of quantitative variables and qualitative variables.}

\item{Y}{Vector containing the outputs of training data points.}

\item{p}{Number of quantitative factors in the given dataset \code{X}.}

\item{q}{Number of qualitative factors in the given dataset \code{X}.}

\item{m}{A vector containing numbers of levels in the qualitative factors.}

\item{tau}{Nugget if needed. The default nugget is 0, otherwise it has to be a non-negative real value.}

\item{lb}{Vector with lower bounds of the parameter estimation. "T" for applying the default setting of lb (a vector of length number of parameters whose elements are all 0.1), otherwise one must provide a vector with length of the number of parameters.}

\item{ub}{Vector with upper bounds of the parameter estimation. "T" for applying the default setting of ub (a vector of length number of parameters whose first \code{q+1} elements are 100 and the rest \code{number of parameters - q - 1} elements are 10), otherwise one must provide a vector with the length being the number of parameters.}

\item{x0}{Vector with starting values for the optimization. "T" for applying the default setting of x0 (a vector made by \code{(lb + ub)/2}), otherwise one must provide a vector with the length being the number of parameters.}

\item{xtol_rel}{Stopping criterion for relative change reached.}

\item{maxeval}{Termination condition by specifying a maximum number of function.}

\item{algorithm}{Optimization algorithm. See \href{https://nlopt.readthedocs.io/en/latest/NLopt_Algorithms/}{NLopt Algorithms} for more availiable algorithms.}
}
\value{
A model of class "EzGP model" list of the following items:
\itemize{
\item{\code{param}} {A list containing the estimated parameters}
\item{\code{data}} {A list containing the dataset and the information for fitting}
}
}
\description{
Fits an Easy-to-Interpret Gaussian process (EzGP) model to a dataset as described in \code{reference 1}.
    The input variables are mixed (with both quantitative and qualitative inputs)
    The output variable is quantitative and scalar.
}
\examples{
# Example with 3 quantitative and 3 qualitative variables (dataset included in the package):
#     Fit an EzGP model (with default settings), and then perform the prediction.
#     This example may run for a while.
p = 3
q = 3
m=c(3,3,3)
tau = 0
X = EzGP_data[1:15, 1:(p+q)]
Y = EzGP_data[1:15, p+q+1]
X_new = EzGP_data[16:20, 1:(p+q)]
# EzGP Model and Prediction
model <- EzGP_fit(X, Y, p, q, m)
pred <- EzGP_predict(X_new, model, MSE_on = 1)
result <- LLF_gradients(X, Y, p, q, m, model$param)
# Results showing
model
pred
result
}
\references{
\enumerate{
\item "EzGP: Easy-to-Interpret Gaussian Process Models for Computer Experiments with Both Quantitative and Qualitative Factors", Qian Xiao, Abhyuday Mandal, C. Devon Lin, and Xinwei Deng (\doi{10.1137/19M1288462})
}
}
\seealso{
\code{\link[EzGP]{EzGP_predict}} to use the fitted EzGP model for prediction.\cr
}
