% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{estimateSynthesis}
\alias{estimateSynthesis}
\title{estimate synthesis parameters.}
\usage{
estimateSynthesis(
  fa,
  M,
  R2Thr = 0.9,
  maxiter = 1000,
  maxconvergence = 100,
  D1 = NA,
  D2 = NA,
  P = NA,
  startpoints = 5
)
}
\arguments{
\item{fa}{data frame with isotope intensities for a FA. First two columns
correspond to Compound and Label information.}

\item{M}{total number of carbons for the FA.}

\item{R2Thr}{positive numeric between 0 and 1 specifying the minimum R2
allowed for fits.}

\item{maxiter}{parameter passed to \link[stats]{nls.control}. Positive integer
specifying the maximum number of iterations allowed.}

\item{maxconvergence}{positive integer specifying the maximum number of
successes before choosing the winning model.}

\item{D1}{positive numeric vector with values between 0 and 1 specifying the
contribution of acetate M+1. If NA it is estimated.}

\item{D2}{positive numeric vector with values between 0 and 1 specifying the
contribution of acetate M+2. If NA it is estimated.}

\item{P}{overdispersion parameter. If NA it is estimated (quasi-multinomial
distribution). If set to 0, no overdispersion is assumed (multinomial
distribution).}

\item{startpoints}{positive integer specifying the number of starting points
for each parameter to be estimated.}
}
\value{
De novo-synthesis and elongation analysis results.
}
\description{
estimate synthesis parameters.
}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
\keyword{internal}
