% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_init_model_function.R
\name{random.init.model}
\alias{random.init.model}
\title{Generate Random Starting Model}
\usage{
random.init.model(number.par, crit.parms = NULL, no.fit = NULL)
}
\arguments{
\item{number.par}{The number of total parameters available.}

\item{crit.parms}{A list containing vectors which specify the critical parameter sets. Needs to be given by index and not by name (for conversion see \code{\link{set.crit.parms}}).}

\item{no.fit}{A vector containing the indices of the parameters which are not to be fitted.}
}
\value{
A vector containing the parameter indices of the random model.
}
\description{
Generates a random starting model (if specified by the user in \code{\link{famos}}), taking into account the critical conditions and the parameters which should not be fitted.
}
\examples{
#set critical conditions
crits <- list(c(1,2,3), c(4,5))
#generate random model
random.init.model(number.par = 20)
random.init.model(number.par = 20, crit.parms = crits)
}
