#' Crop Coefficients (Kc) of Small Vegetables
#'
#' A dataset containing the crop coefficients (Kc) of the small vegetables extracted from Table 12 in
#' "Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56".
#' It is a source to assign a suitable value to the argument \code{Kc} of the function \code{ET_c}.
#'
#' @name Kc_Small_Vegetables
#' @docType data
#'
#' @format A data frame with 13 rows and 4 variables:
#' \describe{
#'   \item{Crop}{name of the crop}
#'   \item{Kc_ini}{the crop coefficient in the growth initial stage}
#'   \item{Kc_mid}{the crop coefficient in the growth mid-season stage}
#'   \item{Kc_end}{the crop coefficient in the growth late-season stage}
#' }
#' @source \url{https://www.fao.org/3/x0490E/x0490e00.htm}
NULL
#'
#' Crop Coefficients (Kc) of Solanum Family Vegetables
#'
#' A dataset containing the crop coefficients (Kc) of the solanum family vegetables extracted from Table 12 in
#' "Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56".
#' It is a source to assign a suitable value to the argument \code{Kc} of the function \code{ET_c}.
#'
#' @name Kc_Vegetables_Solanum_Family
#' @docType data
#'
#' @format A data frame with 4 rows and 4 variables:
#' \describe{
#'   \item{Crop}{name of the crop}
#'   \item{Kc_ini}{the crop coefficient in the growth initial stage}
#'   \item{Kc_mid}{the crop coefficient in the growth mid-season stage}
#'   \item{Kc_end}{the crop coefficient in the growth late-season stage}
#' }
#' @source \url{https://www.fao.org/3/x0490E/x0490e00.htm}
NULL
#'
#' Crop Coefficients (Kc) of Cucumber Family Vegetables
#'
#' A dataset containing the crop coefficients (Kc) of the cucumber family vegetables extracted from Table 12 in
#' "Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56".
#' It is a source to assign a suitable value to the argument \code{Kc} of the function \code{ET_c}.
#'
#' @name Kc_Vegetables_Cucumber_Family
#' @docType data
#'
#' @format A data frame with 7 rows and 4 variables:
#' \describe{
#'   \item{Crop}{name of the crop}
#'   \item{Kc_ini}{the crop coefficient in the growth initial stage}
#'   \item{Kc_mid}{the crop coefficient in the growth mid-season stage}
#'   \item{Kc_end}{the crop coefficient in the growth late-season stage}
#' }
#' @source \url{https://www.fao.org/3/x0490E/x0490e00.htm}
NULL
#'
#' Crop Coefficients (Kc) of Roots and Tubers
#'
#' A dataset containing the crop coefficients (Kc) of the roots and tubers extracted from Table 12 in
#' "Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56".
#' It is a source to assign a suitable value to the argument \code{Kc} of the function \code{ET_c}.
#'
#' @name Kc_Roots_and_Tubers
#' @docType data
#'
#' @format A data frame with 8 rows and 4 variables:
#' \describe{
#'   \item{Crop}{name of the crop}
#'   \item{Kc_ini}{the crop coefficient in the growth initial stage}
#'   \item{Kc_mid}{the crop coefficient in the growth mid-season stage}
#'   \item{Kc_end}{the crop coefficient in the growth late-season stage}
#' }
#' @source \url{https://www.fao.org/3/x0490E/x0490e00.htm}
NULL
#'
#' Crop Coefficients (Kc) of Legumes
#'
#' A dataset containing the crop coefficients (Kc) of the legumes extracted from Table 12 in
#' "Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56".
#' It is a source to assign a suitable value to the argument \code{Kc} of the function \code{ET_c}.
#'
#' @name Kc_Legumes
#' @docType data
#'
#' @format A data frame with 13 rows and 4 variables:
#' \describe{
#'   \item{Crop}{name of the crop}
#'   \item{Kc_ini}{the crop coefficient in the growth initial stage}
#'   \item{Kc_mid}{the crop coefficient in the growth mid-season stage}
#'   \item{Kc_end}{the crop coefficient in the growth late-season stage}
#' }
#' @source \url{https://www.fao.org/3/x0490E/x0490e00.htm}
NULL
#'
#' Crop Coefficients (Kc) of Perennial Vegetables
#'
#' A dataset containing the crop coefficients (Kc) of the perennial vegetables extracted from Table 12 in
#' "Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56".
#' It is a source to assign a suitable value to the argument \code{Kc} of the function \code{ET_c}.
#'
#' @name KC_Perennial_Vegetables
#' @docType data
#'
#' @format A data frame with 4 rows and 4 variables:
#' \describe{
#'   \item{Crop}{name of the crop}
#'   \item{Kc_ini}{the crop coefficient in the growth initial stage}
#'   \item{Kc_mid}{the crop coefficient in the growth mid-season stage}
#'   \item{Kc_end}{the crop coefficient in the growth late-season stage}
#' }
#' @source \url{https://www.fao.org/3/x0490E/x0490e00.htm}
NULL
#'
#' Crop Coefficients (Kc) of Fibre Crops
#'
#' A dataset containing the crop coefficients (Kc) of the fibre crops extracted from Table 12 in
#' "Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56".
#' It is a source to assign a suitable value to the argument \code{Kc} of the function \code{ET_c}.
#'
#' @name Kc_Fibre_Crops
#' @docType data
#'
#' @format A data frame with 3 rows and 4 variables:
#' \describe{
#'   \item{Crop}{name of the crop}
#'   \item{Kc_ini}{the crop coefficient in the growth initial stage}
#'   \item{Kc_mid}{the crop coefficient in the growth mid-season stage}
#'   \item{Kc_end}{the crop coefficient in the growth late-season stage}
#' }
#' @source \url{https://www.fao.org/3/x0490E/x0490e00.htm}
NULL
#'
#' Crop Coefficients (Kc) of Oil Crops
#'
#' A dataset containing the crop coefficients (Kc) of the oil crops extracted from Table 12 in
#' "Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56".
#' It is a source to assign a suitable value to the argument \code{Kc} of the function \code{ET_c}.
#'
#' @name Kc_Oil_Crops
#' @docType data
#'
#' @format A data frame with 8 rows and 4 variables:
#' \describe{
#'   \item{Crop}{name of the crop}
#'   \item{Kc_ini}{the crop coefficient in the growth initial stage}
#'   \item{Kc_mid}{the crop coefficient in the growth mid-season stage}
#'   \item{Kc_end}{the crop coefficient in the growth late-season stage}
#' }
#' @source \url{https://www.fao.org/3/x0490E/x0490e00.htm}
NULL
#'
#' Crop Coefficients (Kc) of Cereals
#'
#' A dataset containing the crop coefficients (Kc) of the cereals extracted from Table 12 in
#' "Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56".
#' It is a source to assign a suitable value to the argument \code{Kc} of the function \code{ET_c}.
#'
#' @name Kc_Cereals
#' @docType data
#'
#' @format A data frame with 17 rows and 4 variables:
#' \describe{
#'   \item{Crop}{name of the crop}
#'   \item{Kc_ini}{the crop coefficient in the growth initial stage}
#'   \item{Kc_mid}{the crop coefficient in the growth mid-season stage}
#'   \item{Kc_end}{the crop coefficient in the growth late-season stage}
#' }
#' @source \url{https://www.fao.org/3/x0490E/x0490e00.htm}
NULL
#'
#' Crop Coefficients (Kc) of Forages
#'
#' A dataset containing the crop coefficients (Kc) of the forages extracted from Table 12 in
#' "Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56".
#' It is a source to assign a suitable value to the argument \code{Kc} of the function \code{ET_c}.
#'
#' @name Kc_Forages
#' @docType data
#'
#' @format A data frame with 15 rows and 4 variables:
#' \describe{
#'   \item{Crop}{name of the crop}
#'   \item{Kc_ini}{the crop coefficient in the growth initial stage}
#'   \item{Kc_mid}{the crop coefficient in the growth mid-season stage}
#'   \item{Kc_end}{the crop coefficient in the growth late-season stage}
#' }
#' @source \url{https://www.fao.org/3/x0490E/x0490e00.htm}
NULL
#'
#' Crop Coefficients (Kc) of Sugar Cane
#'
#' A dataset containing the crop coefficients (Kc) of the sugar cane extracted from Table 12 in
#' "Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56".
#' It is a source to assign a suitable value to the argument \code{Kc} of the function \code{ET_c}.
#'
#' @name Kc_Sugar_Cane
#' @docType data
#'
#' @format A data frame with 1 rows and 4 variables:
#' \describe{
#'   \item{Crop}{name of the crop}
#'   \item{Kc_ini}{the crop coefficient in the growth initial stage}
#'   \item{Kc_mid}{the crop coefficient in the growth mid-season stage}
#'   \item{Kc_end}{the crop coefficient in the growth late-season stage}
#' }
#' @source \url{https://www.fao.org/3/x0490E/x0490e00.htm}
NULL
#'
#' Crop Coefficients (Kc) of Tropical Fruits and Trees
#'
#' A dataset containing the crop coefficients (Kc) of the tropical fruits and trees extracted from Table 12 in
#' "Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56".
#' It is a source to assign a suitable value to the argument \code{Kc} of the function \code{ET_c}.
#'
#' @name Kc_Tropical_Fruits_and_Trees
#' @docType data
#'
#' @format A data frame with 12 rows and 4 variables:
#' \describe{
#'   \item{Crop}{name of the crop}
#'   \item{Kc_ini}{the crop coefficient in the growth initial stage}
#'   \item{Kc_mid}{the crop coefficient in the growth mid-season stage}
#'   \item{Kc_end}{the crop coefficient in the growth late-season stage}
#' }
#' @source \url{https://www.fao.org/3/x0490E/x0490e00.htm}
NULL
#'
#' Crop Coefficients (Kc) of Grapes and Berries
#'
#' A dataset containing the crop coefficients (Kc) of the grapes and berries extracted from Table 12 in
#' "Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56".
#' It is a source to assign a suitable value to the argument \code{Kc} of the function \code{ET_c}.
#'
#' @name Kc_Grapes_and_Berries
#' @docType data
#'
#' @format A data frame with 4 rows and 4 variables:
#' \describe{
#'   \item{Crop}{name of the crop}
#'   \item{Kc_ini}{the crop coefficient in the growth initial stage}
#'   \item{Kc_mid}{the crop coefficient in the growth mid-season stage}
#'   \item{Kc_end}{the crop coefficient in the growth late-season stage}
#' }
#' @source \url{https://www.fao.org/3/x0490E/x0490e00.htm}
NULL
#'
#' Crop Coefficients (Kc) of Fruit Trees
#'
#' A dataset containing the crop coefficients (Kc) of the fruit trees extracted from Table 12 in
#' "Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56".
#' It is a source to assign a suitable value to the argument \code{Kc} of the function \code{ET_c}.
#'
#' @name Kc_Fruit_Trees
#' @docType data
#'
#' @format A data frame with 21 rows and 4 variables:
#' \describe{
#'   \item{Crop}{name of the crop}
#'   \item{Kc_ini}{the crop coefficient in the growth initial stage}
#'   \item{Kc_mid}{the crop coefficient in the growth mid-season stage}
#'   \item{Kc_end}{the crop coefficient in the growth late-season stage}
#' }
#' @source \url{https://www.fao.org/3/x0490E/x0490e00.htm}
NULL
#'
#' Crop Coefficients (Kc) of Wetlands Temperate Climate
#'
#' A dataset containing the crop coefficients (Kc) of the wetlands temperate climate extracted from Table 12 in
#' "Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56".
#' It is a source to assign a suitable value to the argument \code{Kc} of the function \code{ET_c}.
#'
#' @name Kc_Wetlands_Temperate_Climate
#' @docType data
#'
#' @format A data frame with 5 rows and 4 variables:
#' \describe{
#'   \item{Crop}{name of the crop}
#'   \item{Kc_ini}{the crop coefficient in the growth initial stage}
#'   \item{Kc_mid}{the crop coefficient in the growth mid-season stage}
#'   \item{Kc_end}{the crop coefficient in the growth late-season stage}
#' }
#' @source \url{https://www.fao.org/3/x0490E/x0490e00.htm}
NULL
#'
#' Crop Coefficients (Kc) of Special Areas
#'
#' A dataset containing the crop coefficients (Kc) of the special areas extracted from Table 12 in
#' "Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56".
#' It is a source to assign a suitable value to the argument \code{Kc} of the function \code{ET_c}.
#'
#' @name Kc_Special
#' @docType data
#'
#' @format A data frame with 2 rows and 3 variables:
#' \describe{
#'   \item{Crop}{name of the crop}
#'   \item{Kc_ini}{the crop coefficient in the growth initial stage}
#'   \item{Kc_mid}{the crop coefficient in the growth mid-season stage}
#'   \item{Kc_end}{the crop coefficient in the growth late-season stage}
#' }
#' @source \url{https://www.fao.org/3/x0490E/x0490e00.htm}
NULL
