% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VapPres.R
\name{AtmPres}
\alias{AtmPres}
\title{Atmospheric Pressure (P)}
\usage{
AtmPres(z)
}
\arguments{
\item{z}{A numeric scalar that denotes elevation above sea level [m].}
}
\value{
The function returns the value of the atmospheric pressure as a numeric scalar.
}
\description{
\code{AtmPres} returns the value of atmospheric pressure.
}
\details{
This is a function to calculate the atmospheric pressure [kPa] based on the elevation above the sea level.
}
\section{Reference}{

\href{https://www.fao.org/3/x0490E/x0490e00.htm}{Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998).
   \emph{Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56}.
   Fao, Rome, 300(9), D05109.}
}

\examples{
AtmPres(z = 1800)

}
\seealso{
\code{\link{PsyCon}}.
}
