% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitboot.R
\name{lassofit}
\alias{lassofit}
\title{Fits effective noise of LASSO regressions}
\usage{
lassofit(x, y, q.levels = c(0.90, 0.95, 0.99), p.value = FALSE,
         numboot = 1000L, nlambda = 100L,
         lambda.factor = ifelse(nobs < nvars, 1e-02, 1e-04), 
         lambda = NULL, pf = rep(1, nvars),
         dfmax = nvars + 1, 
         pmax = min(dfmax * 1.2, nvars), standardize = FALSE, 
         intercept = FALSE, eps = 1e-08, maxit = 1000000L)
}
\arguments{
\item{x}{T by p data matrix, where T and p respectively denote the sample size and the number of regressors.}

\item{y}{T by 1 response variable.}

\item{q.levels}{quantile levels of effective noise.}

\item{p.value}{whether pvalue should be computed. Default is \code{FALSE}.}

\item{numboot}{bootstrap replications.}

\item{nlambda}{number of \eqn{\lambda}'s to use in the regularization path; used if \code{lambda = NULL}.}

\item{lambda.factor}{The factor for getting the minimal \eqn{\lambda} in the \eqn{\lambda} sequence, where \code{min(lambda) = lambda.factor * max(lambda)}. max(lambda) is the smallest value of lambda for which all coefficients are zero. \ifelse{html}{\out{&lambda; <sub>max</sub>}}{\eqn{\lambda_{max}}} is determined for each \eqn{\gamma} tuning parameter separately. The default depends on the relationship between \code{T} (the sample size) and \code{p} (the number of predictors). If \code{T < p}, the default is \code{0.01}. If \code{T > p}, the default is \code{0.0001}, closer to zero. The smaller the value of \code{lambda.factor} is, the denser is the fit for \ifelse{html}{\out{&lambda;<sub>min</sub>}}{\eqn{\lambda_{min}}}. Used only if \code{lambda = NULL}.}

\item{lambda}{a user-supplied lambda sequence. By leaving this option unspecified (recommended), users can have the program compute its own \code{lambda} sequence based on \code{nlambda} and \code{lambda.factor.} It is better to supply, if necessary, a decreasing sequence of lambda values than a single (small) value, as warm-starts are used in the optimization algorithm. The program will ensure that the user-supplied \eqn{\lambda} sequence is sorted in decreasing order before fitting the model.}

\item{pf}{the \ifelse{html}{\out{&#8467;<sub>1</sub>}}{\eqn{\ell_1}} penalty factor of length \code{p} used for the adaptive sg-LASSO. Separate \ifelse{html}{\out{&#8467;<sub>1</sub>}}{\eqn{\ell_1}} penalty weights can be applied to each coefficient to allow different \ifelse{html}{\out{&#8467;<sub>1</sub>}}{\eqn{\ell_1}} + \ifelse{html}{\out{&#8467;<sub>2,1</sub>}}{\eqn{\ell_{2,1}}} shrinkage. Can be 0 for some variables, which imposes no shrinkage, and results in that variable always be included in the model. Default is 1 for all variables.}

\item{dfmax}{the maximum number of variables allowed in the model. Useful for very large \code{p} when a partial path is desired. Default is \code{p+1}. In case \code{method='fe'}, \code{dfmax} is ignored.}

\item{pmax}{the maximum number of coefficients allowed ever to be nonzero. For example, once \ifelse{html}{\out{&beta;<sub>i</sub> &#8800; 0}}{\eqn{\beta_i \neq 0}}  for some \ifelse{html}{\out{i &#8712; [p]}}{\eqn{i\in[p]}}, no matter how many times it exits or re-enters the model through the path, it will be counted only once. Default is \code{min(dfmax*1.2, p)}.}

\item{standardize}{logical flag for variable standardization, prior to fitting the model sequence. The coefficients are always returned to the original scale. It is recommended to keep \code{standardize=TRUE}. Default is \code{FALSE}.}

\item{intercept}{whether intercept be fitted (\code{TRUE}) or set to zero (\code{FALSE}). Default is \code{FALSE}. In case \code{method='pooled'}, \code{intercept=TRUE} is forced. In case \code{method='fe'}, \code{intercept=FALSE} is forced and \code{entity} specific intercepts are fitted in a separate output variable \code{a0}.}

\item{eps}{convergence threshold for block coordinate descent. Each inner block coordinate-descent loop continues until the maximum change in the objective after any coefficient update is less than thresh times the null deviance. Defaults value is \code{1e-8}.}

\item{maxit}{maximum number of outer-loop iterations allowed at fixed lambda values. Default is \code{1e6}. If the algorithm does not converge, consider increasing \code{maxit}.}
}
\value{
lassofit object.
}
\description{
Fits effective noise of LASSO regressions.
}
\details{
Fits effective noise of LASSO regressions.
}
\examples{
set.seed(1)
x = matrix(rnorm(100 * 20), 100, 20)
beta = c(5,4,3,2,1,rep(0, times = 15))
y = x\%*\%beta + rnorm(100)
lassofit(x = x, y = y)
}
\author{
Jonas Striaukas
}
