% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window_fava.R
\name{window_fava}
\alias{window_fava}
\title{Compute FAVA in sliding windows.}
\usage{
window_fava(
  relab_matrix,
  window_size,
  window_step = 1,
  group = NULL,
  index = NULL,
  time = NULL,
  w = NULL,
  S = NULL,
  K = NULL,
  normalized = FALSE,
  alpha = 0.5
)
}
\arguments{
\item{relab_matrix}{A matrix or data frame with rows containing non-negative entries that sum to 1. Each row represents
a sample, each column represents a category, and each entry represents the abundance of that category in the sample.
If \code{relab_matrix} contains any metadata, it must be on the left-hand side of the matrix,
the right \code{K} entries of each row must sum to 1, and \code{K} must be specified. Otherwise, all entries of
each row must sum to 1.}

\item{window_size}{An integer number specifying the number of samples per window.}

\item{window_step}{Optional; an integer specifying the distance between the first entry of adjacent windows. Default is \code{window_step=1}.}

\item{group}{Optional; a string specifying the name of the column that describes which group each row (sample) belongs to. Use if \code{relab_matrix} is a single matrix containing multiple groups of samples you wish to compare.}

\item{index}{Optional; a string specifying the name of the column in \code{relab_matrix} containing an index for each sample. For example, if \code{relab_matrix} contains time series data, \code{index} would be the column containing the time of each sample. If \code{index} is not specified but \code{time} is, \code{time} is by default used as the index.}

\item{time}{Optional; a string specifying the name of the column that describes the sampling time for each row. Include if you wish to weight FAVA by the distance between samples.}

\item{w}{Optional; a vector of length \code{I} with non-negative entries that sum to 1. Entry \code{w[i]} represents the weight placed on row \code{i} in the computation of the mean abundance of each category across rows. The default value is \code{w = rep(1/nrow(relab_matrix), nrow(relab_matrix))}.}

\item{S}{Optional; a K x K similarity matrix with diagonal elements equal to 1 and off-diagonal elements between 0 and 1. Entry \code{S[i,k]} for \code{i!=k} is the similarity between category and \code{i} and category \code{k}, equaling 1 if the categories are to be treated as identical and equaling 0 if they are to be treated as totally dissimilar. The default value is \code{S = diag(ncol(relab_matrix))}.}

\item{K}{Optional; an integer specifying the number of categories in the data. Default is \code{K=ncol(relab_matrix)}.}

\item{normalized}{Optional; should normalized FAVA be used? Default is \code{normalized = FALSE}; use \code{normalized = TRUE} to compute normalized FAVA. FAVA can only be normalized if it is not weighted.}

\item{alpha}{Optional; number between 0 and 1 specifying the opacity of the horizontal
lines plotted. Default is \code{alpha = 0.5}.}
}
\value{
A list of values of FAVA for each window.
}
\description{
This function computes FAVA in sliding window slices of a dataset.
}
\examples{
A = matrix(c(.3,.7,0,.1,0,.9,.2,.5,.3,.1,.8,.1,.3,.4,.3,.6,.4,0,0,.5,.5),
           ncol = 3, byrow = TRUE)
window_out = window_fava(relab_matrix = A, window_size = 4, normalized = TRUE)
}
