% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fbms.R
\name{fbms}
\alias{fbms}
\title{Fit a BGNLM Model Using MJMCMC or GMJMCMC Sampling.}
\usage{
fbms(
  formula = NULL,
  family = "gaussian",
  beta_prior = list(type = "g-prior"),
  model_prior = NULL,
  extra_params = NULL,
  data = NULL,
  impute = FALSE,
  loglik.pi = NULL,
  method = "mjmcmc",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{formula}{A formula object specifying the model structure. Default is NULL.}

\item{family}{The distribution family of the response variable. Currently supports "gaussian", "binomial", "poisson", "gamma", and  "custom". Default is "gaussian".}

\item{beta_prior}{Type of prior as a string (default: "g-prior" with a = max(n, p^2)). Possible values include:
- "beta.prime": Beta-prime prior (GLM/Gaussian, no additional args)
- "CH": Compound Hypergeometric prior (GLM/Gaussian, requires \code{a}, \code{b}, optionally \code{s})
- "EB-local": Empirical Bayes local prior (GLM/Gaussian, requires \code{a} for Gaussian)
- "EB-global": Empirical Bayes local prior (Gaussian, requires \code{a} for Gaussian)
- "g-prior": Zellner's g-prior (GLM/Gaussian, requires \code{g})
- "hyper-g": Hyper-g prior (GLM/Gaussian, requires \code{a})
- "hyper-g-n": Hyper-g/n prior (GLM/Gaussian, requires \code{a})
- "tCCH": Truncated Compound Hypergeometric prior (GLM/Gaussian, requires \code{a}, \code{b}, \code{s}, \code{rho}, \code{v}, \code{k})
- "intrinsic": Intrinsic prior (GLM/Gaussian, no additional args)
- "TG": Truncated Gamma prior (GLM/Gamma, requires \code{a}, \code{s})
- "Jeffreys": Jeffreys prior (GLM/Gaussian, no additional args)
- "uniform": Uniform prior (GLM/Gaussian, no additional args)
- "benchmark": Benchmark prior (Gaussian/GLM, no additional args)
- "ZS-adapted": Zellner-Siow adapted prior (Gaussian TCCH, no additional args)
- "robust": Robust prior (Gaussian/GLM, no additional args)
- "Jeffreys-BIC": Jeffreys prior with BIC approximation of marginal likelihood (Gaussian/GLM)
- "ZS-null": Zellner-Siow null prior (Gaussian, requires \code{a})
- "ZS-full": Zellner-Siow full prior (Gaussian, requires \code{a})
- "hyper-g-laplace": Hyper-g Laplace prior (Gaussian, requires \code{a})
- "AIC": AIC prior from BAS (Gaussian, requires penalty \code{a})
- "BIC": BIC prior from BAS (Gaussian/GLM)
- "JZS": Jeffreys-Zellner-Siow prior (Gaussian, requires \code{a})
\itemize{
\item r: Model complexity penalty (default: 1/n)
\item g: Tuning parameter for g-prior (default: max(n, p^2))
\item a, b, s, v, rho, k: Hyperparameters for various priors
\item n: Sample size for some priors (default: length(y))
\item var: Variance assumption for Gaussian models ("known" or "unknown", default: "unknown")
\item laplace: Logical for Laplace approximation in GLM only (default: FALSE)
}}

\item{model_prior}{a list with parameters of model priors, by default r should be provided}

\item{extra_params}{extra parameters to be passed to the loglik.pi function}

\item{data}{A data frame or matrix containing the data to be used for model fitting. If the outcome variable is in the first column of the data frame, the formula argument in fbms can be omitted, provided that all other columns are intended to serve as input covariates.}

\item{impute}{TRUE  means imputation combined with adding a dummy column with indicators of imputed values, FALSE (default) means only full data is used.}

\item{loglik.pi}{Custom function to compute the logarithm of the posterior mode based on logarithm of marginal likelihood and logarithm of prior functions (needs specification only used if family = "custom")}

\item{method}{Which fitting algorithm should be used, currently implemented options include "gmjmcmc", "gmjmcmc.parallel", "mjmcmc" and "mjmcmc.parallel" with "mjmcmc" being the default and 'mjmcmc' means that only linear models will be estimated}

\item{verbose}{If TRUE, print detailed progress information during the fitting process. Default is TRUE.}

\item{...}{Additional parameters to be passed to the underlying method.}
}
\value{
An object containing the results of the fitted model and MCMC sampling.
}
\description{
This function fits a model using the relevant MCMC sampling. The user can specify the formula,
family, data, transforms, and other parameters to customize the model.
}
\examples{
# Fit a Gaussian multivariate time series model
fbms_result <- fbms(
 X1 ~ .,
 family = "gaussian",
 method = "gmjmcmc.parallel",
 data = data.frame(matrix(rnorm(600), 100)),
 transforms = c("sin","cos"),
 P = 10,
 runs = 1,
 cores = 1
)
summary(fbms_result)


}
\seealso{
\code{\link{mjmcmc}}, \code{\link{gmjmcmc}}, \code{\link{gmjmcmc.parallel}}
}
