% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.gmjmcmc}
\alias{summary.gmjmcmc}
\title{Function to Print a Quick Summary of the Results}
\usage{
\method{summary}{gmjmcmc}(
  object,
  pop = "best",
  tol = 1e-04,
  labels = FALSE,
  effects = NULL,
  data = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{The results to use}

\item{pop}{The population to print for, defaults to last}

\item{tol}{The tolerance to use as a threshold when reporting the results.}

\item{labels}{Should the covariates be named, or just referred to as their place in the data.frame.}

\item{effects}{Quantiles for posterior modes of the effects across models to be reported, if either effects are NULL or if labels are NULL, no effects are reported.}

\item{data}{Data to merge on, important if pre-filtering was used}

\item{verbose}{If the summary should be printed to the console or just returned, defaults to TRUE}

\item{...}{Not used.}
}
\value{
A data frame containing the following columns:
\item{feats.strings}{Character representation of the features ordered by marginal probabilities.}
\item{marg.probs}{Marginal probabilities corresponding to the ordered feature strings.}
}
\description{
Function to Print a Quick Summary of the Results
}
\examples{
result <- gmjmcmc(y = matrix(rnorm(100), 100),
x = matrix(rnorm(600), 100), 
P = 2, 
transforms =  c("p0", "exp_dbl"))
summary(result, pop = "best")

}
