% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beamUDL.R
\name{beamUDL}
\alias{beamUDL}
\title{beamUDL}
\usage{
beamUDL(beamP, beamT, Length, fx, fy)
}
\arguments{
\item{beamP}{Matrix (2 x n) of beam coordinates.}

\item{beamT}{Matrix (2 x n) containing the number of the coordinate point as shown in beamP that connect to form a given beam (Discretization table).}

\item{Length}{Length of beam.}

\item{fx}{Load value (newtons) in the x direction.}

\item{fy}{Load value (newtons) in the y direction.}
}
\value{
Produces matrix representing uniformly distributed load on beam
\item{DLMatrix}{Column matrix for beam distributed load}
\item{ExpandedDLMatrix}{Expanded beam distribution load}
\item{ReductedDLMatrix}{Reduced beam distribution load}
}
\description{
Uniformly distributes load over the length of the beam.
}
\examples{
data(beamGeo)
data(beamDime)

Length = beamDime$Length
beamUDL = beamUDL(beamGeo$beamP, beamGeo$beamT, Length, beamGeo$fx, beamGeo$fy)

}
