% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sabr.R
\name{Nsvh1Choi2019}
\alias{Nsvh1Choi2019}
\title{Calculate the option price under the NSVh model with lambda=1 (Choi et al. 2019)}
\usage{
Nsvh1Choi2019(
  strike = forward,
  spot,
  texp = 1,
  sigma,
  vov = 0,
  rho = 0,
  intr = 0,
  divr = 0,
  cp = 1L,
  forward = spot * exp(-divr * texp)/df,
  df = exp(-intr * texp)
)
}
\arguments{
\item{strike}{(vector of) strike price}

\item{spot}{(vector of) spot price}

\item{texp}{(vector of) time to expiry}

\item{sigma}{(vector of) volatility}

\item{vov}{(vector of) vol-of-vol}

\item{rho}{(vector of) correlation}

\item{intr}{interest rate}

\item{divr}{dividend rate}

\item{cp}{call/put sign. \code{1} (default) for call price, \code{-1} for put price,
\code{NULL} for Bachelier volatility}

\item{forward}{forward price. If given, \code{forward} overrides \code{spot}}

\item{df}{discount factor. If given, \code{df} overrides \code{intr}}
}
\value{
BS volatility or option price based on \code{cp}
}
\description{
Calculate the option price under the NSVh model with lambda=1 (Choi et al. 2019)
}
\examples{

spot <- 100
strike <- seq(80,125,5)
texp <- 1.2
sigma <- 20
vov <- 0.2
rho <- -0.5
strike <- seq(0.1, 2, 0.1)

FER::Nsvh1Choi2019(strike, spot, texp, sigma, vov, rho)

}
\references{
Choi, J., Liu, C., & Seo, B. K. (2019). Hyperbolic normal
  stochastic volatility model. Journal of Futures Markets, 39(2), 186–204.
  \doi{10.1002/fut.21967}
}
