% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FIESTA-package.R
\docType{package}
\name{FIESTA-package}
\alias{FIESTA-package}
\alias{FIESTA}
\title{FIESTA - Forest Inventory Estimation for Analysis}
\description{
FIESTA is a research estimation tool for analysts that work with sample-based 
inventory data from the U.S. Department of Agriculture, Forest Service, 
Forest Inventory and Analysis (FIA) Program.
}
\details{
FIESTA can generate FIA's traditional state-wide estimates while also accommodate: 
unique population boundaries, different evaluation time periods, customized 
stratification schemes, non-standard variance equations, integration of 
multi-scale remotely-sensed data and other auxiliary information, and 
interaction with other modeling and estimation tools from CRAN's library of 
packages. 

FIESTA contains a collection of functions that can query FIA databases, 
summarize and compile plot and spatial data, and generate estimates with 
associated sampling errors.
}
\references{
Bechtold, William A.; Patterson, Paul L.; [Editors] 2005. The enhanced
forest inventory and analysis program - national sampling design and
estimation procedures. Gen. Tech. Rep. SRS-80. Asheville, NC: U.S.
Department of Agriculture, Forest Service, Southern Research Station. 85p.

R Development Core Team (2011). R: A language and environment for
statistical computing. R Foundation for Statistical Computing, Vienna,
Austria. ISBN 3-900051-07-0, URL http://www.R-project.org/.

Burrill, E.A., Wilson, A.M., Turner, J.A., Pugh, S.A., Menlove, J.,
Christiansen, G., Conkling, B.L., Winnie, D., 2018. Forest Inventory and
Analysis Database [WWW Document].  St Paul MN US Dep. Agric. For. Serv.
North. Res. Stn.  URL http://apps.fs.fed.us/fiadb-downloads/datamart.html
(accessed 3.6.21).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://usdaforestservice.github.io/FIESTA/}
  \item \url{https://github.com/USDAForestService/FIESTA}
  \item Report bugs at \url{https://github.com/USDAForestService/FIESTA/issues}
}

}
\author{
Tracey S. Frescino Maintainer: Tracey S. Frescino
}
\keyword{package}
