% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSAUtils.R
\name{se}
\alias{se}
\title{Computes standard error of the mean.}
\usage{
se(x, na.rm = TRUE)
}
\arguments{
\item{x}{A numeric vector.}

\item{na.rm}{A logical that indicates whether missing values should be removed before computing the standard error.}
}
\value{
A single numeric that is the standard error of the mean of \code{x}.
}
\description{
Computes the standard error of the mean (i.e., standard deviation divided by the square root of the sample size).
}
\details{
The standard error of the value in vector \code{x} is simply the standard deviation of \code{x} divided by the square root of the number of valid items in \code{x}
}
\examples{
# example vector
x <- 1:20
se(x)
sd(x)/sqrt(length(x))   ## matches

# all return NA if missing values are not removed
x2 <- c(x,NA)
sd(x2)/sqrt(length(x2))

# Better if missing values are removed
se(x2)              ## Default behavior
sd(x2,na.rm=TRUE)/sqrt(length(x2[complete.cases(x2)]))  ## Matches
se(x2,na.rm=FALSE)  ## Result from not removing NAs

}
\seealso{
See \code{se} in \pkg{sciplot} for similar functionality.
}
\author{
Derek H. Ogle, \email{DerekOgle51@gmail.com}
}
\keyword{manip}
