% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaheuristic.R
\name{whaleOptimization}
\alias{whaleOptimization}
\title{Whale Optimization Algorithm (Binary Whale Optimization Algorithm)}
\usage{
whaleOptimization(population = 10, iter = 10, verbose = FALSE)
}
\arguments{
\item{population}{The number of whales population}

\item{iter}{The number of iterations of the algorithm}

\item{verbose}{Print the partial results in each iteration}
}
\value{
Returns a search function that is used to guide the feature selection process.
}
\description{
Generates a search function based on the whale optimization algorithm. This function is called internally within the \code{\link{searchAlgorithm}} function. Binary Whale Optimization Algorithm \insertCite{Kumar2018}{FSinR} is an algorithm that simulates the social behavior of humpback whales. This algorithm employs a binary version of the bubble-net hunting strategy. The algorithm starts with an initial population of individuals, and in each iteration updates the individuals according to several possible actions: Encircling prey, Bubble-net attacking or Search for prey
}
\examples{
\donttest{ 

## The direct application of this function is an advanced use that consists of using this 
# function directly and performing a search process in a feature space
## Classification problem

# Generates the filter evaluation function
filter_evaluator <- filterEvaluator('IEConsistency')

# Generates the search function with WOA
woa_search <- whaleOptimization()
# Performs the search process directly (parameters: dataset, target variable and evaluator)
woa_search(iris, 'Species', filter_evaluator)
}
}
\references{
\insertAllCited{}
}
\author{
Francisco Aragón Royón
}
