% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fACF_test.R
\name{fACF_test}
\alias{fACF_test}
\title{Test based on fACF}
\usage{
fACF_test(
  f_data,
  H = 10,
  iid = FALSE,
  M = NULL,
  pplot = FALSE,
  alpha = 0.05,
  suppress_raw_output = FALSE,
  suppress_print_output = FALSE
)
}
\arguments{
\item{f_data}{A \eqn{J \times N} matrix of functional time series data, where \eqn{J} is the number of discrete points in a grid and \eqn{N} is the sample size.}

\item{H}{A positive integer specifying the maximum lag for which test statistic is computed.}

\item{iid}{A Boolean value. If given TRUE, the hypothesis test will use the strong-white
noise (SWN) assumption instead of the weak white noise (WWN) assumption.}

\item{M}{A positive integer specifying the number of Monte Carlo simulations used to approximate the null distribution under the WWN assumption.
If \eqn{M = NULL, M = \text{floor}((\max(150 - N, 0) + \max(100 - J, 0) + (J / \sqrt{2})))},
ensuring that the number of Monte Carlo simulations is adequate based on the dataset size.}

\item{pplot}{A Boolean value. If TRUE, the function will produce a plot of p-values of the test
as a function of maximum lag \eqn{H}, ranging from \eqn{H=1} to \eqn{H=20}, which may increase the computation time.}

\item{alpha}{A numeric value between 0 and 1 indicating the significance level for the test.}

\item{suppress_raw_output}{A Boolean value. If TRUE, the function will not return the list
containing the p-value, quantile, and statistic.}

\item{suppress_print_output}{A Boolean value. If TRUE, the function will not print any
output to the console.}
}
\value{
If suppress_raw_output = FALSE, a list that includes the test statistic, the \eqn{(1-\alpha)} quantile of the
limiting distribution, and the p-value from the specified hypothesis test. Additionally, if suppress_print_output = FALSE,
a summary is printed with a brief explanation of the test, the p-value, and relevant details about the test procedure.
}
\description{
This function performs a hypothesis test using a test statistic computed from functional autocovariance kernels of a FTS.
}
\details{
The test statistic is the sum of the squared \eqn{L^2}-norm of the sample autocovariance kernels:
\deqn{
KRS_{N,H} = N \sum_{h=1}^H \|\hat{\gamma}_{N,h}\|^2,
}
where
   \eqn{
   \hat{\gamma}_{N,h}(t,s)=N^{-1}\sum_{i=1}^{N-h} (X_i(t)-\bar{X}_N(t))(X_{i+h}(s)-\bar{X}_N(s))},
   \eqn{\bar{X}_N(t) = N^{-1} \sum_{i=1}^N X_i(t)}.
This test assesses the cumulative significance of lagged autocovariance kernels, up to a
user-selected maximum lag \eqn{H}. A higher value of \eqn{KRS_{N,H}} suggests a potential
departure of the observed series from white noise process. The approximated null
distribution of this statistic is developed under both the strong and weak white noise assumptions.
}
\examples{
\donttest{
data(sp500) # S&P500 index
fACF_test(OCIDR(sp500), H = 10, pplot=TRUE)
}
}
\references{
[1] Kokoszka P., Rice G., Shang H.L. (2017). Inference for the autocovariance of a functional time series
under conditional heteroscedasticity. Journal of Multivariate Analysis, 162, 32-50.
}
