% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IDch.R
\name{IDch}
\alias{IDch}
\title{IDs of children of ego}
\usage{
IDch(idego, d = NULL, keep_ego = FALSE)
}
\arguments{
\item{idego}{ID of ego(s). If the vector idego includes missing elements (NA), they are removed.}

\item{d}{Name of database. If d is missing, the dataset dLH in the global environment (R workspace) is used. 
If no dLH in the global environment, the database dLH distributed with the Families package is used.}

\item{keep_ego}{Logical variable. If TRUE, a dataframe of parent-child and father-child dyads is produced. 
It includes, for each ego (parent), ego's ID and the IDs of ego's children.}
}
\value{
Two cases:
\itemize{
 \item keep_ego=FALSE: IDch() returns the IDs of children. If ego has no children or IDs of children are not
included in database, the missing data symbol NA is returned. The
vector idego may include the IDs of egos who form a couple. In that case, the IDs of their children are included 
only once to prevent double-counting.
 \item keep_ego=TRUE: IDch() returns a dataframe of parent-child dyads. If idego includes the IDs of egos 
 who form a couple, then the IDs of their children are included twice, in the mother-child dyads and
 in the father-child dyads. To select the father-child dyads, select the male egos. The dataframe of parent-child
 dyads include childless females and males. The dyad has the ID of the female(male) and NA instead of the 
 ID of the child. The object returned has the following columns: 
 \itemize{
   \item ID of ego (parent of child)
   \item ID of child
   }
}
}
\description{
Retrieves IDs of children of ego(s).
}
\examples{
# Load the data
data(dLH,package=("Families"))

IDch(idego=1)
set.seed(43)
id <- sample (dLH$ID[dLH$gen==1],10)
id2 <- IDch(idego=sort(id),keep_ego=TRUE)
id3 <- IDch(id2$idch,keep_ego=TRUE)


}
