% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/FastKNN.R
\name{knn_test_function}
\alias{knn_test_function}
\title{KNN Test
The knn_test_function returns the labels for a test set using the k-Nearest Neighbors Clasification method.}
\usage{
knn_test_function(dataset, test, distance, labels, k = 3)
}
\arguments{
\item{dataset}{is a matrix with the features of the training set}

\item{test}{is a matrix where the columns are the features of the test set}

\item{distance}{is a nxn matrix with the distance between each observation of the test set
and the training set}

\item{labels}{is a nx1 vector with the labels of the training set}

\item{k}{is from the numeric class and represent the number of neigbours to be use in the classifier.}
}
\value{
a k vector with the predicted labels for the test set.
}
\description{
KNN Test
The knn_test_function returns the labels for a test set using the k-Nearest Neighbors Clasification method.
}
\examples{
# Create Data for restaurant reviews
training <- matrix(rexp(600,1), ncol=2)
test  <- matrix(rexp(200,1), ncol=2)
# Label "Good", "Bad", "Average"
labelsExample <- c(rep("Good",100), rep("Bad",100), rep("Average",100))
# Distance Matrix
distanceExample<-Distance_for_KNN_test(test, training)
# KNN
knn_test_function(training, test, distanceExample,labelsExample, k = 3)
}
\seealso{
\code{k.nearest.neighbors}

\code{sample}
}

