% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FateID_functions.R
\name{plotFateMap}
\alias{plotFateMap}
\title{Plot dimensional reduction representation of the expression data}
\usage{
plotFateMap(
  y,
  dr,
  x = NULL,
  g = NULL,
  n = NULL,
  prc = FALSE,
  logsc = FALSE,
  k = 2,
  m = "cmd",
  kr = NULL,
  col = NULL,
  fb = NULL,
  trthr = NULL,
  start = NULL,
  tp = 1,
  seed = 12345,
  ...
)
}
\arguments{
\item{y}{clustering partition. A vector with an integer cluster number for each cell. The order of the cells has to be the same as for the columns of x.}

\item{dr}{list of dimensional reduction representations returned by the function \code{compdr}.}

\item{x}{expression data frame with genes as rows and cells as columns. Gene IDs should be given as row names and cell IDs should be given as column names. This can be a reduced expression table only including the features (genes) to be used in the analysis. This input has to be provided if \code{g} (see below) is given and corresponds to a valid gene ID, i. e. one of the rownames of \code{x}. The default value is \code{NULL}. In this case, cluster identities are highlighted in the plot.}

\item{g}{either the name of one of the trajectories from \code{fb} or a gene ID corresponding to one of the rownames of \code{x}. In the latter case, the input argument \code{x} needs to be provided. A vector of gene IDs can also be provided. In this case, the aggregated expression across all gene IDs is plotted. If \code{g} equals E, then the entropy of fate bias is displayed. The default value is \code{NULL}. In this case, cluster identities are highlighted in the plot.}

\item{n}{optional character string. This argument corresponds to a title for 2-dimensional plots. Default value is \code{NULL}. If not provided, and \code{g} is given, then \code{n} will equal \code{g} or g[1], respectively, if g is a vector of gene IDs.}

\item{prc}{logical. If \code{TRUE}, then a principal curve is computed and returned. Default is \code{FALSE}.}

\item{logsc}{logical. If \code{TRUE}, then gene expression of fate bias probabilities are plotted on a log2 scale. Default value is \code{FALSE}.}

\item{k}{integer number for the dimension to be used. This dimension has to be present in \code{dr}. Only \code{k=2} is allowed starting from version 0.1.9.}

\item{m}{name of the dimensional reduction algorithms to be used for the principal curve computation. One of \code{cmd}, \code{dm}, \code{tsne}, \code{umap}. Default value is \code{cmd}. Has to be a component of \code{dr}, i.e. previously computed by \code{compdr}.}

\item{kr}{integer vector. If \code{k}>3 then \code{kr} indicates the dimensions to be plotted (either two or three of all possible dimensions). Default value is \code{NULL}. In this case, \code{kr} is given by \code{1:min(k,3)}.}

\item{col}{optional vector of valid color names for all clusters in \code{y} ordered by increasing cluster number. Default value is \code{NULL}.}

\item{fb}{fateBias object returned by the function \code{fateBias}. If \code{fb} is provided, then a principal curve is computed and shown in the plot. Default value is \code{NULL}. The curve is only displayed if \code{g} equal \code{NULL}.}

\item{trthr}{real value representing the threshold of the fraction of random forest votes required for the inclusion of a given cell for the computation of the principal curve. If \code{NULL} then only cells with a significant bias >1 are included for each trajectory. The bias is computed as the ratio of the number of votes for a trajectory and the number of votes for the trajectory with the second largest number of votes. By this means only the trajectory with the largest number of votes will receive a bias >1. The siginifcance is computed based on counting statistics on the difference in the number of votes. A significant bias requires a p-value < 0.05. Default value is \code{NULL}.}

\item{start}{integer number representing a specified starting cluster number for all trajectories, i. e. a common progenitor cluster. The argument is optional. Default value is \code{NULL}.}

\item{tp}{Transparency of points in the plot to allow better visibility of the principal curves. Default value is 1, i. e. non-transparent.}

\item{seed}{integer number. Random seed for determining colour scheme. Default is 12345.}

\item{...}{additional arguments to be passed to the low level function \code{principal_curve}.}
}
\value{
If \code{fb} is provided as input argument and \code{prc} equals \code{TRUE} then the output corresponds to the output of \code{prcurve}. Otherwise, only ouput is generated is \code{g} equals E. In this case a vector of fate bias entropies for all cells is given.
}
\description{
This function plots a dimensional reduction representation using the output of the \code{compdr} function as input. It allows display of the input clusters as well as color coding of fate bias probabilities and gene expression.
}
\examples{

x <- intestine$x
y <- intestine$y
# v contains all genes (no feature selection like in x)
v <- intestine$v
fcol <- intestine$fcol
tar <- c(6,9,13)
fb <- fateBias(x,y,tar,z=NULL,minnr=5,minnrh=10,nbfactor=5,use.dist=FALSE,seed=NULL,nbtree=NULL)
dr <- compdr(x,z=NULL,m="cmd",k=2,tsne.perplexity=30)

# plot principal curves
pr <- plotFateMap(y,dr,k=2,prc=TRUE,m="cmd",col=fcol,fb=fb,trthr=0.25,start=NULL,tp=.5)

# plot expression of gene Apoa1__chr9
plotFateMap(y,dr,x=v,g="Apoa1__chr9",prc=FALSE,k=2,m="cmd",col=intestine$fcol)

}
