% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FateID_functions.R
\name{plotexpressionProfile}
\alias{plotexpressionProfile}
\title{Plotting smoothed pseudo-temporal expression profiles for groups of genes}
\usage{
plotexpressionProfile(
  x,
  y,
  g,
  n,
  logsc = FALSE,
  col = NULL,
  name = NULL,
  cluster = FALSE,
  alpha = 0.5,
  lwd = 1,
  ylim = NULL,
  seed = 12345,
  ylab = NULL
)
}
\arguments{
\item{x}{expression data frame with genes as rows and cells as columns. Gene IDs should be given as row names and cell IDs should be given as column names.}

\item{y}{clustering partition. A vector with an integer cluster number for each cell. The order of the cells has to be the same as for the columns of \code{x}.}

\item{g}{a gene ID corresponding to one of the rownames of \code{x}. It can also be vector of gene IDs. In this case, a separate profile is plotted for each gene in \code{g}.}

\item{n}{ordered vector of cell IDs to be included. Cell IDs need to be column names of \code{x}.}

\item{logsc}{logical value. If \code{TRUE}, then log2-transformed values are plotted. Default is \code{FALSE} and untransformed values are plotted.}

\item{col}{optional vector of valid color names used for the profiles of all genes in \code{g}. Default value is \code{NULL}.}

\item{name}{optional character string. This argument corresponds to a title for the plot. Default value is \code{NULL}. If not provided, and \code{g} is given, then \code{name} will equal \code{g} or \code{g[1]}, respectively, if \code{g} is a vector of gene IDs.}

\item{cluster}{logical value. If \code{TRUE} then the partitioning along the x-axis is indicated be vertical lines representing the boundaries of all positions with a given value in \code{y}. The average position across all cells in a cluster will be indicated on the x-axis.}

\item{alpha}{positive real number. Pseudo-temporal expression profiles are derived by a local regression of expression values across the ordered cells using the function \code{loess} from the package \pkg{stats}. This is the parameter, which controls the degree of smoothing. Larger values return smoother profiles. Default value is 0.5.}

\item{lwd}{line width of profiles. Default value is 1.}

\item{ylim}{vector of two numerical values: lower and upper limit of values shown on the y-axis. Default value is \code{NULL} and the whole range is shown.}

\item{seed}{integer number. Random seed for determining colour scheme. Default is 12345.}

\item{ylab}{Optional label for the y-axis. Default is \code{NULL} and axis is labeled "norm. expression".}
}
\value{
None
}
\description{
This function allows plotting loess-smoothed pseudo-temporal expression profiles for groups of genes. To display gene expression profiles on the same scale, row sums are normalized to one.
}
\examples{

\donttest{
x <- intestine$x
y <- intestine$y
v <- intestine$v
fcol <- intestine$col
tar <- c(6,9,13)
fb <- fateBias(x,y,tar,z=NULL,minnr=5,minnrh=10,nbfactor=5,use.dist=FALSE,seed=NULL,nbtree=NULL)
dr <- compdr(x,z=NULL,m="cmd",k=2,tsne.perplexity=30)
pr <- prcurve(y,fb,dr,k=2,m="cmd",trthr=0.4,start=NULL)
n <- pr$trc[["t6"]]
fs  <- filterset(v,n,minexpr=2,minnumber=1)
s1d <- getsom(fs,nb=1000,alpha=.5)
ps <- procsom(s1d,corthr=.85,minsom=3)
# plot average profile of all genes of node 1 in the self-organizing map
g <- sample(names(ps$nodes)[ps$nodes == 1],5)
plotexpressionProfile(v,y,g,n,col=fcol,name="Node 1",alpha=.2)
}

}
