% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfe_removeR.R
\encoding{UTF-8}
\name{rfeTerminator}
\alias{rfeTerminator}
\title{Recursive Feature Engineering SelectoR}
\usage{
rfeTerminator(
  df,
  x_cols,
  y_cols,
  method = "cv",
  kfolds = 10,
  sizes = c(1:100),
  alter_df = TRUE,
  eval_funcs = rfFuncs,
  ...
)
}
\arguments{
\item{df}{data frame to fit the recursive feature engineering algorithm to}

\item{x_cols}{the independent variables to be used for the recursive feature engineering algorithm}

\item{y_cols}{the dependent variables to be used in the prediction}

\item{method}{\strong{\emph{Default = "cv"}}- cross validation method for resampling, other options "repeatedcv"}

\item{kfolds}{\emph{Default = 10} - the number of k folds - train / test splits to compute when resampling}

\item{sizes}{the sizes of the search boundary for the search}

\item{alter_df}{\emph{Default = TRUE} - will remove the redundant features, due to having a lesser affect on the mean decrease in accuracy, or other measures.}

\item{eval_funcs}{\emph{Default = rfFuncs} (Random Forest Mean Decrease Accuracy method). Other options: rfe, lmFuncs, rfFuncs, treebagFuncs, nbFuncs, pickSizeBest, pickSizeTolerance.}

\item{...}{Function forwarding to main `caret::rfe() function` to pass in additional parameters native to caret}
}
\value{
A list containing the outputs highlighted hereunder:
\itemize{
\item{\strong{"rfe_model_fit_results"}}{ a list of the model fit results. Including the optimal features}
\item{\strong{"rfe_reduced_features"}}{ a data.frame object with the reduced variables and data}
\item{\strong{"rfe_original_data"}}{ a data.frame object with the original data passed for manual exclusion based on fit outputs}
\item{\strong{"rfe_reduced_data"}}{output of setting the alter_df=TRUE will remove the features / IVs from the data.frame}
}
}
\description{
This function removes the redundant features in a model and automatically selects the best combination of features to remove.
This utilises, by default, the random forest mean decrease in accuracy methods, from the caret package, reference Kuhn (2021).
This function is a wrapper for the \strong{rfe()} function
}
\details{
With the df_alter set to TRUE the recursive feature algorithm chosen will automatically remove the features from the returned tibble embedded in the list.
}
\examples{
library(caret)
library(tibble)
library(FeatureTerminatoR)
library(dplyr)
df <- iris
# Passing in the indexes as slices x values located in index 1:4 and y value in location 5
rfe_fit <- rfeTerminator(df, x_cols= 1:4, y_cols=5, alter_df = TRUE, eval_funcs = rfFuncs)
#Explore the optimal model results
print(rfe_fit$rfe_model_fit_results)
# Explore the optimal variables selected
print(rfe_fit$rfe_model_fit_results$optVariables)
# Explore the original data passed to the frame
print(head(rfe_fit$rfe_original_data))
# Explore the data adapted with the less important features removed
print(head(rfe_fit$rfe_reduced_data))
}
\references{
Kuhn (2021) Recursive Feature Elimination. \url{https://topepo.github.io/caret/recursive-feature-elimination.html}
}
