% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NLCD_FUNCTIONS.R
\name{get_nlcd_annual}
\alias{get_nlcd_annual}
\title{Download and crop the Annual National Land Cover Database.}
\usage{
get_nlcd_annual(
  template,
  label,
  year = 2023,
  product = "LndCov",
  region = "CU",
  collection = 1,
  version = 0,
  extraction.dir = file.path(tempdir(), "FedData", "extractions", "nlcd_annual", label),
  raster.options = c("COMPRESS=DEFLATE", "ZLEVEL=9"),
  force.redo = FALSE
)
}
\arguments{
\item{template}{An \code{\link[sf:sf]{Simple Feature}}
or \code{\link[terra:SpatRaster-class]{terra}} object to serve as a template for cropping.}

\item{label}{A character string naming the study area.}

\item{year}{An integer vector representing the year of desired NLCD product.
Acceptable values are currently 1985 through 2023 (defaults to 2023).}

\item{product}{A character vector representing type of the NLCD product.
Defaults to 'LndCov' (Land Cover).\cr
LndCov = Land Cover\cr
LndChg = Land Cover Change\cr
LndCnf = Land Cover Confidence\cr
FctImp = Fractional Impervious Surface\cr
ImpDsc = Impervious Descriptor\cr
SpcChg = Spectral Change Day of Year\cr}

\item{region}{A character string representing the region to be extracted
Acceptable values are 'CU' (Conterminous US, the default),
'AK' (Alaska), and 'HI' (Hawaii). \strong{Currently, only 'CU' is available.}}

\item{collection}{An integer representing the collection number.
\strong{Currently, only '1' is available.}}

\item{version}{An integer representing the version number.
\strong{Currently, only '0' is available.}}

\item{extraction.dir}{A character string indicating where the extracted
and cropped NLCD data should be put. The directory will be created if missing.}

\item{raster.options}{a vector of GDAL options passed to \link[terra:writeRaster]{terra::writeRaster}.}

\item{force.redo}{If an extraction for this template and label already exists,
should a new one be created?}
}
\value{
A \code{RasterLayer} cropped to the bounding box of the template.
}
\description{
\code{get_nlcd_annual} returns a \code{\link[terra:SpatRaster-class]{SpatRaster}} of NLCD data cropped to a given
template study area. The Annual NLCD is currently only available for the conterminous United States.
More information about the Annual NLCD product is available on the
\href{https://www.mrlc.gov/data/project/annual-nlcd}{Annual NLCD web page}.
}
\examples{
\dontrun{
# Extract data for the Mesa Verde National Park:

# Get the NLCD (USA ONLY)
# Returns a raster
NLCD_ANNUAL <-
  get_nlcd_annual(
    template = FedData::meve,
    label = "meve",
    year = 2020,
    product =
      c(
        "LndCov",
        "LndChg",
        "LndCnf",
        "FctImp",
        "ImpDsc",
        "SpcChg"
      )
  )

NLCD_ANNUAL
}
}
